/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;

public class SmartInstaller
extends JPanel
implements ActionListener {
    int BUFFER = 1024;
    JFrame mainFrame;
    JTextArea logArea;
    String[] configurations = new String[]{"32 bits", "64 bits"};
    JRadioButton[] configurationButtons;
    String[] programChoosers = new String[]{"R", "R Color Brewer Package", "R HMisc Package", "Python 2.6", "S-MART"};
    JCheckBox[] programChooserButtons;
    JButton goButton;
    JButton installDirectoryChooserButton;
    JTextField installDirectoryChooserTextField;

    public SmartInstaller() {
        JComponent jComponent;
        JComponent jComponent2;
        Box box = Box.createVerticalBox();
        JPanel jPanel = new JPanel(false);
        JTextArea jTextArea = new JTextArea("This is the S-MART installation tool.\r\nIt will download and install the needed softwares, as well as S-MART itself.\r\nYou can unselect the software that you already have installed.\r\nDuring the installation, accept all the default parameters.");
        TitledBorder titledBorder = BorderFactory.createTitledBorder("Welcome to the S-MART installer!");
        jTextArea.setEditable(false);
        jTextArea.setBackground(jPanel.getBackground());
        jPanel.add(jTextArea);
        jPanel.setBorder(titledBorder);
        JPanel jPanel2 = new JPanel(false);
        jPanel2.setLayout(new GridLayout(1, 0));
        this.configurationButtons = new JRadioButton[this.configurations.length];
        ButtonGroup buttonGroup = new ButtonGroup();
        for (int i = 0; i < this.configurations.length; ++i) {
            jComponent2 = new JRadioButton(this.configurations[i]);
            jPanel2.add(jComponent2);
            this.configurationButtons[i] = jComponent2;
            buttonGroup.add((AbstractButton)jComponent2);
        }
        this.configurationButtons[0].setSelected(true);
        TitledBorder titledBorder2 = BorderFactory.createTitledBorder("Configuration");
        jPanel2.setBorder(titledBorder2);
        jComponent2 = new JPanel(false);
        jComponent2.setLayout(new GridLayout(0, 1));
        JLabel jLabel = new JLabel("Choose which programs to install:");
        jComponent2.add(jLabel);
        this.programChooserButtons = new JCheckBox[this.programChoosers.length];
        for (int i = 0; i < this.programChoosers.length; ++i) {
            jComponent = new JCheckBox(this.programChoosers[i]);
            ((AbstractButton)jComponent).setSelected(true);
            jComponent2.add(jComponent);
            this.programChooserButtons[i] = jComponent;
        }
        TitledBorder titledBorder3 = BorderFactory.createTitledBorder("Programs");
        jComponent2.setBorder(titledBorder3);
        jComponent = new JPanel(false);
        jComponent.setLayout(new GridLayout(1, 0));
        JLabel jLabel2 = new JLabel("Choose a directory to install S-MART: ");
        this.installDirectoryChooserTextField = new JTextField();
        this.installDirectoryChooserButton = new JButton("Open...");
        this.installDirectoryChooserButton.addActionListener(this);
        jComponent.add(jLabel2);
        jComponent.add(this.installDirectoryChooserTextField);
        jComponent.add(this.installDirectoryChooserButton);
        TitledBorder titledBorder4 = BorderFactory.createTitledBorder("Installation directory");
        jComponent.setBorder(titledBorder4);
        JPanel jPanel3 = new JPanel(false);
        this.goButton = new JButton("GO!");
        this.goButton.addActionListener(this);
        this.goButton.setSelected(true);
        jPanel3.add(this.goButton);
        TitledBorder titledBorder5 = BorderFactory.createTitledBorder("Start install");
        jPanel3.setBorder(titledBorder5);
        this.logArea = new JTextArea(10, 120);
        this.logArea.setFont(new Font("Monospaced", this.logArea.getFont().getStyle(), this.logArea.getFont().getSize()));
        JScrollPane jScrollPane = new JScrollPane(this.logArea, 22, 30);
        TitledBorder titledBorder6 = BorderFactory.createTitledBorder("Log");
        jScrollPane.setBorder(titledBorder6);
        GridLayout gridLayout = new GridLayout(1, 0);
        box.add(jPanel);
        box.add(jPanel2);
        box.add(jComponent2);
        box.add(jComponent);
        box.add(jPanel3);
        box.add(jScrollPane);
        this.add(box);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.goButton) {
            boolean[] blArray = new boolean[this.programChoosers.length];
            for (int i = 0; i < this.programChoosers.length; ++i) {
                blArray[i] = this.programChooserButtons[i].isSelected();
            }
            SmartInstallerTask smartInstallerTask = new SmartInstallerTask(this.logArea, blArray, this.installDirectoryChooserTextField.getText(), this.configurationButtons[0].isSelected() ? 0 : 1);
            smartInstallerTask.execute();
        } else if (actionEvent.getSource() == this.installDirectoryChooserButton) {
            JFileChooser jFileChooser = new JFileChooser();
            jFileChooser.setFileSelectionMode(1);
            if (jFileChooser.showOpenDialog(this.mainFrame) == 0) {
                this.installDirectoryChooserTextField.setText(jFileChooser.getSelectedFile().getPath());
            }
        }
    }

    private static void createAndShowGUI() {
        JFrame jFrame = new JFrame("S-Mart Installer");
        jFrame.setDefaultCloseOperation(3);
        SmartInstaller smartInstaller = new SmartInstaller();
        smartInstaller.setOpaque(true);
        jFrame.setContentPane(smartInstaller);
        jFrame.pack();
        jFrame.setVisible(true);
    }

    public static void main(String[] stringArray) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SmartInstaller.createAndShowGUI();
            }
        });
    }
}

