#! /usr/bin/env python
"""Transform a plain text file to a FASTA file"""

import os
from optparse import OptionParser
from structure.sequence import *
from misc.progress import *


if __name__ == "__main__":
  
  # parse command line
  parser = OptionParser()
  description = "Txt to Fasta: Convert a Txt file (one sequence per line) into Fasta file. [Category: Personnal]"

  parser = OptionParser(description = description)
  parser.add_option("-i", "--input",           dest="inputFileName",  action="store",                     type="string", help="input file [compulsory] [format: file in TXT format]")
  parser.add_option("-o", "--output",          dest="outputFileName", action="store",                     type="string", help="output file [compulsory] [format: output file in FASTA format]")
  parser.add_option("-v", "--verbosity",       dest="verbosity",      action="store",      default=1,     type="int",    help="trace level [format: int]")
  (options, args) = parser.parse_args()

  inputFile = open(options.inputFileName)
  outputFile = open(options.outputFileName, "w")
  
  for line in inputFile:
    line = line.strip()
    outputFile.write(">%s\n%s\n" % (line, line))
  
  inputFile.close()
  outputFile.close()
