import unittest
import struct
import os
from SMART.Java.Python.structure.Interval import Interval
from SMART.Java.Python.ncList.FindOverlapsWithOneInterval import FindOverlapsWithOneInterval
from SMART.Java.Python.misc import Utils

class Test_F_FindOverlapsWithOneInterval(unittest.TestCase):

    def setUp(self):
        self._inputGff3FileName = 'sortedFile.gff3'
        self._writeGFF3File(self._inputGff3FileName)
        self._obsFileName = "overlap.gff3"
        self._expFileName = "expFile.gff3"
        self._iFOWOI = FindOverlapsWithOneInterval(0)
        self._iFOWOI.setFileName(self._inputGff3FileName, "gff3")
        self._iFOWOI.setOutputFileName(self._obsFileName)
        
    def tearDown(self):
        os.remove(self._inputGff3FileName)
        os.remove(self._obsFileName)
        os.remove(self._expFileName)
        
    def test_run_general(self):
        self._iFOWOI.setInterval("chr1", 500, 850)
        self._iFOWOI.run()
        self._writeExpGFF3File_general(self._expFileName)
        self.assertTrue(Utils.diff(self._expFileName, self._obsFileName))
        
#   def test_run_general_asScript(self):
#       cmd = 'python ../FindOverlapsWithOneInterval.py -i %s -f gff3 -o %s -c chr1 -s 500 -e 850 -v 0' % (self._inputGff3FileName, self._obsFileName)
#       os.system(cmd)
#       self._writeExpGFF3File_general(self._expFileName)
#       self.assertTrue(Utils.diff(self._expFileName, self._obsFileName))
#       
#   def test_run_one_overlap(self):
#       self._iFOWOI.setInterval("chr1", 1250, 1450)
#       self._iFOWOI.run()
#       self._writeExpGFF3File_one_overlap(self._expFileName)
#       self.assertTrue(Utils.diff(self._expFileName, self._obsFileName))
#       
#   def test_run_one_overlap_asScript(self):
#       cmd = 'python ../FindOverlapsWithOneInterval.py -i %s -f gff3 -o %s -c chr1 -s 1250 -e 1450 -v 0' % (self._inputGff3FileName, self._obsFileName)
#       os.system(cmd)
#       self._writeExpGFF3File_one_overlap(self._expFileName) 
#       self.assertTrue(Utils.diff(self._expFileName, self._obsFileName))       
#       
#   def test_run_all_overlap(self):
#       self._iFOWOI.setInterval("chr1", 300, 1250)
#       self._iFOWOI.run()
#       self._writeExpGff3File_all_overlap(self._expFileName)
#       self.assertTrue(Utils.diff(self._expFileName, self._obsFileName))
#       
#   def test_run_all_overlap_asScript(self):
#       cmd = 'python ../FindOverlapsWithOneInterval.py -i %s -f gff3 -o %s -c chr1 -s 300 -e 1250 -v 0' % (self._inputGff3FileName, self._obsFileName)
#       os.system(cmd)        
#       self._writeExpGff3File_all_overlap(self._expFileName)
#       self.assertTrue(Utils.diff(self._expFileName, self._obsFileName))
#               
#   def test_run_no_overlap_right(self):
#       self._iFOWOI.setInterval("chr1", 1400, 1500)
#       self._iFOWOI.run()
#       f = open(self._expFileName, "w")
#       f.close()
#       self.assertTrue(Utils.diff(self._expFileName, self._obsFileName))
#       
#   def test_run_no_overlap_right_asScript(self):
#       cmd = 'python ../FindOverlapsWithOneInterval.py -i %s -f gff3 -o %s -c chr1 -s 1400 -e 1500 -v 0' % (self._inputGff3FileName, self._obsFileName)
#       os.system(cmd)           
#       f = open(self._expFileName, "w")
#       f.close()
#       self.assertTrue(Utils.diff(self._expFileName, self._obsFileName))
#               
#   def test_run_no_overlap_left(self):
#       self._iFOWOI.setInterval("chr1", 0, 8)
#       self._iFOWOI.run()
#       f = open(self._expFileName, "w")
#       f.close()
#       self.assertTrue(Utils.diff(self._expFileName, self._obsFileName))
#       
#   def test_run_no_overlap_left_asScript(self):
#       cmd = 'python ../FindOverlapsWithOneInterval.py -i %s -f gff3 -o %s -c chr1 -s 0 -e 8 -v 0' % (self._inputGff3FileName, self._obsFileName)
#       os.system(cmd)  
#       f = open(self._expFileName, "w")
#       f.close()
#       self.assertTrue(Utils.diff(self._expFileName, self._obsFileName))                

    def _writeExpGff3File_all_overlap(self, fileName):  
        f = open(fileName, 'w')
        f.write("chr1\tS-MART\ttest2.1\t9\t1000\t1001\t+\t.\tID=test2.1;Name=test2.1\n")
        f.write("chr1\tS-MART\ttest2.2\t50\t350\t301\t+\t.\tID=test2.2;Name=test2.2\n")
        f.write("chr1\tS-MART\ttest2.3\t100\t600\t501\t+\t.\tID=test2.3;Name=test2.3\n")
        f.write("chr1\tS-MART\ttest2.4\t200\t450\t251\t+\t.\tID=test2.4;Name=test2.4\n")
        f.write("chr1\tS-MART\ttest2.5\t700\t950\t251\t+\t.\tID=test2.5;Name=test2.5\n")
        f.write("chr1\tS-MART\ttest2.6\t800\t900\t101\t+\t.\tID=test2.6;Name=test2.6\n")
        f.write("chr1\tS-MART\ttest2.7\t1200\t1300\t101\t+\t.\tID=test2.7;Name=test2.7\n")
        f.close()
        
    def _writeExpGFF3File_one_overlap(self, fileName):
        f = open(fileName, "w")
        f.write("chr1\tS-MART\ttest2.7\t1200\t1300\t101\t+\t.\tID=test2.7;Name=test2.7\n")
        f.close()    
        
    def _writeExpGFF3File_general(self, fileName):
        f = open(fileName, "w")
        f.write("chr1\tS-MART\ttranscript\t500\t850\t.\t+\t.\tnbOverlaps=4;overlapsWith=test2.1--test2.3--test2.5--test2.6\n")
        f.close()
        
    def _writeGFF3File(self, fileName):
        f = open(fileName, "w")
        f.write("chr1\ttest\ttest2.1\t9\t1000\t1001\t+\t.\tID=test2.1;Name=test2.1\n")
        f.write("chr1\ttest\ttest2.2\t50\t350\t301\t+\t.\tID=test2.2;Name=test2.2\n")
        f.write("chr1\ttest\ttest2.3\t100\t600\t501\t+\t.\tID=test2.3;Name=test2.3\n")
        f.write("chr1\ttest\ttest2.4\t200\t450\t251\t+\t.\tID=test2.4;Name=test2.4\n")
        f.write("chr1\ttest\ttest2.5\t700\t950\t251\t+\t.\tID=test2.5;Name=test2.5\n")
        f.write("chr1\ttest\ttest2.6\t800\t900\t101\t+\t.\tID=test2.6;Name=test2.6\n")
        f.write("chr1\ttest\ttest2.7\t1200\t1300\t101\t+\t.\tID=test2.7;Name=test2.7\n")
        f.close()

if __name__ == "__main__":
    unittest.main()
