#! /usr/bin/env python
#
# Copyright INRA-URGI 2009-2010
# 
# This software is governed by the CeCILL license under French law and
# abiding by the rules of distribution of free software. You can use,
# modify and/ or redistribute the software under the terms of the CeCILL
# license as circulated by CEA, CNRS and INRIA at the following URL
# "http://www.cecill.info".
# 
# As a counterpart to the access to the source code and rights to copy,
# modify and redistribute granted by the license, users are provided only
# with a limited warranty and the software's author, the holder of the
# economic rights, and the successive licensors have only limited
# liability.
# 
# In this respect, the user's attention is drawn to the risks associated
# with loading, using, modifying and/or developing or reproducing the
# software by the user in light of its specific status of free software,
# that may mean that it is complicated to manipulate, and that also
# therefore means that it is reserved for developers and experienced
# professionals having in-depth computer knowledge. Users are therefore
# encouraged to load and test the software's suitability as regards their
# requirements in conditions enabling the security of their systems and/or
# data to be ensured and, more generally, to use and operate it in the
# same conditions as regards security.
# 
# The fact that you are presently reading this means that you have had
# knowledge of the CeCILL license and that you accept its terms.
#
"""Convert a FASTQ file to a FASTA file"""

import os
import sys
from optparse import OptionParser
from SMART.Java.Python.misc.RPlotter import RPlotter
from SMART.Java.Python.misc.Progress import Progress
from math import *

if __name__ == "__main__":
    
    # parse command line
    description = "FastQ to FastA v1.0.1: Convert a FastQ file into a FastA file. [Category: Personnal]"

    parser = OptionParser(description = description)
    parser.add_option("-i", "--input", dest="inputFileName", action="store", type="string", help="input file [compulsory] [format: file in FASTQ format]")
    parser.add_option("-o", "--output", dest="outputFileName", action="store", type="string", help="output file [compulsory] [format: output file in FASTA format]")
    parser.add_option("-v", "--verbosity", dest="verbosity", action="store", default=1, type="int", help="trace level [default: 1] [format: int]")
    (options, args) = parser.parse_args()

    inputFile = open(options.inputFileName)
    outputFastaFile = open(options.outputFileName, "w")
    
    inSequenceName = False
    inQualityName = False
    inSequence = False
    inQuality = True
    sequenceName = None
    lineNumber = 1
    
    for line in inputFile:

        if inSequenceName:
            inSequence = True
            inSequenceName = False
        elif inQualityName:
            inQuality = True
            inQualityName = False
        elif inSequence:
            inQualityName = True
            inSequence = False
        elif inQuality:
            inSequenceName = True
            inQuality = False
        else:
            sys.exit("Error! Do not in which section I am (line is %d)" % (lineNumber))

        line = line.strip()
        if inSequenceName:
            if line[0] != "@":
                sys.exit("Error! Sequence name '%s' does not start with '@' (line is %d)" % (line, lineNumber))
            sequenceName = line[1:]
            outputFastaFile.write(">%s\n" % (sequenceName))
        elif inQualityName:
            if line[0] != "+":
                sys.exit("Error! Quality name '%s' does not start with '+' (line is %d)" % (line, lineNumber))
            if len(line) > 1 and sequenceName != line[1:]:
                sys.exit("Names in sequence and qual are different (%s, %s) (line is %d)" % (sequenceName, line[1:], lineNumber))
        elif inSequence:
            outputFastaFile.write("%s\n" % (line))
        elif inQuality:
            pass
        lineNumber += 1
    
    inputFile.close()
    outputFastaFile.close()
