#! /usr/bin/env python
#
# Copyright INRA-URGI 2009-2010
# 
# This software is governed by the CeCILL license under French law and
# abiding by the rules of distribution of free software. You can use,
# modify and/ or redistribute the software under the terms of the CeCILL
# license as circulated by CEA, CNRS and INRIA at the following URL
# "http://www.cecill.info".
# 
# As a counterpart to the access to the source code and rights to copy,
# modify and redistribute granted by the license, users are provided only
# with a limited warranty and the software's author, the holder of the
# economic rights, and the successive licensors have only limited
# liability.
# 
# In this respect, the user's attention is drawn to the risks associated
# with loading, using, modifying and/or developing or reproducing the
# software by the user in light of its specific status of free software,
# that may mean that it is complicated to manipulate, and that also
# therefore means that it is reserved for developers and experienced
# professionals having in-depth computer knowledge. Users are therefore
# encouraged to load and test the software's suitability as regards their
# requirements in conditions enabling the security of their systems and/or
# data to be ensured and, more generally, to use and operate it in the
# same conditions as regards security.
# 
# The fact that you are presently reading this means that you have had
# knowledge of the CeCILL license and that you accept its terms.
#
"""Transform a plain text file to a FASTA file"""

import os
from optparse import OptionParser
from SMART.Java.Python.structure.Sequence import *
from SMART.Java.Python.misc.Progress import *


if __name__ == "__main__":
    
    # parse command line
    parser = OptionParser()
    description = "Txt to Fasta v1.0.1: Convert a Txt file (one sequence per line) into Fasta file. [Category: Personnal]"

    parser = OptionParser(description = description)
    parser.add_option("-i", "--input",     dest="inputFileName",  action="store",            type="string", help="input file [compulsory] [format: file in TXT format]")
    parser.add_option("-o", "--output",    dest="outputFileName", action="store",            type="string", help="output file [compulsory] [format: output file in FASTA format]")
    parser.add_option("-v", "--verbosity", dest="verbosity",      action="store", default=1, type="int",    help="trace level [format: int]")
    (options, args) = parser.parse_args()

    inputFile = open(options.inputFileName)
    outputFile = open(options.outputFileName, "w")
    
    for line in inputFile:
        line = line.strip()
        splittedLine = line.split()
        sequence = splittedLine[0]
        nb = 1 if len(splittedLine) == 1 else int(splittedLine[1])
        for i in range(nb):
            outputFile.write(">%s\n%s\n" % (sequence, sequence))
    
    inputFile.close()
    outputFile.close()
