/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.JTextArea;
import javax.swing.SwingWorker;

public class ProgramLauncher
extends SwingWorker<Boolean, String> {
    String[] command;
    JTextArea logArea;
    JLabel messageField;
    JProgressBar progressBar;
    JLabel etaField;
    int exitValue;
    CountDownLatch latch;

    public ProgramLauncher(LinkedList<String> linkedList, JTextArea jTextArea, JLabel jLabel, JProgressBar jProgressBar, JLabel jLabel2) {
        this.command = new String[linkedList.size()];
        this.logArea = jTextArea;
        this.messageField = jLabel;
        this.progressBar = jProgressBar;
        this.etaField = jLabel2;
        this.exitValue = -1;
        linkedList.toArray(this.command);
        this.latch = new CountDownLatch(1);
    }

    public ProgramLauncher(String[] stringArray, JTextArea jTextArea, JLabel jLabel, JProgressBar jProgressBar, JLabel jLabel2) {
        this.command = stringArray;
        this.logArea = jTextArea;
        this.messageField = jLabel;
        this.progressBar = jProgressBar;
        this.etaField = jLabel2;
        this.exitValue = -1;
        this.latch = new CountDownLatch(1);
    }

    @Override
    public Boolean doInBackground() {
        Object object;
        ProcessBuilder processBuilder = new ProcessBuilder(this.command);
        Process process = null;
        BufferedReader bufferedReader = null;
        processBuilder = processBuilder.redirectErrorStream(true);
        Map<String, String> map = processBuilder.environment();
        map.put("PYTHONPATH", System.getProperty("user.dir") + File.separator + "Python");
        map.put("SMARTPATH", System.getProperty("user.dir") + File.separator + "Python");
        map.put("SMARTMYSQLPATH", Global.mysqlCommand);
        map.put("SMARTRPATH", Global.rCommand);
        String string = Arrays.toString(this.command);
        try {
            this.publish("=== Starting command '" + string.trim() + "' ===\n");
            process = processBuilder.start();
            object = new BufferedInputStream(process.getInputStream());
            InputStream inputStream = process.getInputStream();
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
            bufferedReader = new BufferedReader(inputStreamReader);
        }
        catch (Exception exception) {
            this.publish("!Process cannot be started (command is '" + string + "')!\n");
            exception.printStackTrace();
            this.latch.countDown();
            return Boolean.FALSE;
        }
        if (bufferedReader == null) {
            this.publish("!Problem in the output of the command!\n");
            this.latch.countDown();
            return Boolean.FALSE;
        }
        try {
            while ((object = bufferedReader.readLine()) != null) {
                this.publish((String)object + "\n");
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            this.publish("!Cannot get the output of the command!\n");
            this.latch.countDown();
            return Boolean.FALSE;
        }
        try {
            process.waitFor();
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
            this.publish("!Cannot wait for the end of the command!\n");
            this.latch.countDown();
            return Boolean.FALSE;
        }
        try {
            this.exitValue = process.exitValue();
        }
        catch (IllegalThreadStateException illegalThreadStateException) {
            illegalThreadStateException.printStackTrace();
            this.publish("!Cannot get the exit value of the command!\n");
            this.latch.countDown();
            return Boolean.FALSE;
        }
        if (this.exitValue != 0) {
            this.publish("!Problem during the execution of the command '" + string + "'!\n");
            this.latch.countDown();
            return Boolean.FALSE;
        }
        this.publish("=== Ending command '" + string.trim() + "' ===\n");
        this.latch.countDown();
        return Boolean.TRUE;
    }

    @Override
    protected void process(List<String> list) {
        String string = "";
        String string2 = this.logArea.getText();
        for (String string3 : list) {
            string2 = string2 + string3;
        }
        for (String string4 : string2.split("\n")) {
            for (String string5 : string4.split("\r")) {
                int n;
                Object object;
                boolean bl = false;
                if (string5.matches(".*\\[=*\\s*\\]\\s*\\d*/\\d*\\s*")) {
                    object = string5.split("\\]")[1].trim().split("/");
                    int n2 = Integer.parseInt(object[0].trim());
                    n = Integer.parseInt(object[1].trim());
                    this.messageField.setText(string5.split("\\[")[0].trim());
                    this.progressBar.setValue(n2 * 100 / n);
                    this.etaField.setText("");
                    bl = true;
                } else if (string5.matches(".*\\[=*\\s*\\]\\s*\\d*/\\d*\\s*ETA:\\s*.*")) {
                    object = string5.split("\\]")[1].split("E")[0].trim().split("/");
                    int n3 = Integer.parseInt(object[0].trim());
                    n = Integer.parseInt(object[1].trim());
                    String string6 = string5.split("ETA:")[1].trim();
                    this.messageField.setText(string5.split("\\[")[0].trim());
                    this.progressBar.setValue(n3 * 100 / n);
                    this.etaField.setText("ETA: " + string6);
                    bl = true;
                } else if (string5.matches(".*\\[=*\\s*\\]\\s*\\d*\\s*completed in.*")) {
                    object = string5.split("\\]")[1].split("completed")[0].trim();
                    String string7 = string5.split("completed in")[1].trim();
                    string = string + string5.split("\\[")[0].trim() + ": " + (String)object + " elements completed in " + string7 + "\n";
                    this.messageField.setText(string5.split("\\[")[0].trim());
                    bl = true;
                }
                if (bl) continue;
                string = string + string5 + "\n";
            }
        }
        String[] stringArray = string.split("\n");
        String string8 = "";
        for (int i = Math.max(0, stringArray.length - Global.logAreaSize); i < stringArray.length; ++i) {
            string8 = string8 + stringArray[i] + "\n";
        }
        this.logArea.setText(string8);
    }

    public int getExitValue() {
        try {
            this.latch.await();
        }
        catch (InterruptedException interruptedException) {
            this.logArea.append("Cannot wait for the end of the process!\n");
            interruptedException.printStackTrace();
            return -1;
        }
        return this.exitValue;
    }
}

