import unittest
import os, os.path
from SMART.Java.Python.misc import Utils


TestF_PATH = os.environ['REPET_PATH'] + '/SMART/Java/Python/TestFiles'


class Test_F_findTss(unittest.TestCase):
    
    def setUp(self):
        self._outputFileName = 'output.gff3'
        self._expOutputFileName = 'expOutput.gff3'
        
    def tearDown(self):
        os.remove(self._outputFileName)
        os.remove(self._expOutputFileName)

    def test_run_default_option(self):
        cmd = "python ../findTss.py -i %s/mapperAnalyzerExpected.gff3 -f gff3 -o output.gff3 -v 0" % TestF_PATH
        os.system(cmd)
        self._writeExpDefaultOption(self._expOutputFileName)
        self.assertTrue(Utils.diff(self._expOutputFileName, self._outputFileName))
        
    def test_run_normalize_option(self):
        cmd = "python ../findTss.py -i %s/mapperAnalyzerExpected.gff3 -f gff3 -o output.gff3 -n -v 0" % TestF_PATH
        os.system(cmd)
        self._writeExpNormalizeOption(self._expOutputFileName)
        self.assertTrue(Utils.diff(self._expOutputFileName, self._outputFileName))

    def test_run_distance_option(self):
        cmd = "python ../findTss.py -i %s/mapperAnalyzerExpected.gff3 -f gff3 -o output.gff3 -d 20 -v 0" % TestF_PATH
        os.system(cmd)
        self._writeExpDistance_option(self._expOutputFileName)
        self.assertTrue(Utils.diff(self._expOutputFileName, self._outputFileName))

    def test_run_colinear_option(self):
        cmd = "python ../findTss.py -i %s/mapperAnalyzerExpected.gff3 -f gff3 -o output.gff3 -e -v 0" % TestF_PATH
        os.system(cmd)
        self._writeExpColinearOption(self._expOutputFileName)
        self.assertTrue(Utils.diff(self._expOutputFileName, self._outputFileName))
        
    def test_run_excel_option(self):
        cmd = "python ../findTss.py -i %s/mapperAnalyzerExpected.gff3 -f gff3 -o output.gff3 -c output.csv -v 0" % TestF_PATH
        os.system(cmd)
        obsCsv = 'output.csv'
        self.assertTrue(os.path.exists(obsCsv))
        os.remove(obsCsv)
        self._writeExpExcelOption(self._expOutputFileName)
        self.assertTrue(Utils.diff(self._expOutputFileName, self._outputFileName))

    def _writeExpDefaultOption(self, fileName):
        f = open(fileName, 'w')
        f.write("chr1\tS-MART\tmatch\t6155418\t6155418\t24\t+\t.\toccurrence=1;rank=1;bestRegion=(self);nbGaps=0;nbOccurrences=1;nbMismatches=0;ID=test1/1;identity=100;Name=test1/1\n")
        f.write("chr2\tS-MART\tmatch\t26303950\t26303950\t32\t+\t.\toccurrence=1;rank=1;bestRegion=(self);nbGaps=0;nbOccurrences=3;nbMismatches=2;ID=test2/1-1;identity=93;Name=test2/1\n")
        f.write("chr3\tS-MART\tmatch\t28320540\t28320540\t35\t+\t.\toccurrence=2;bestRegion=chr2:26303950-26303981;nbGaps=0;nbOccurrences=3;nbMismatches=2;ID=test2/1-2;identity=94;Name=test2/1\n")
        f.write("chr4\tS-MART\tmatch\t28565007\t28565007\t35\t+\t.\toccurrence=3;rank=3;bestRegion=chr2:26303950-26303981;nbGaps=0;nbOccurrences=3;nbMismatches=4;ID=test2/1-3;identity=88;Name=test2/1\n")
        f.close()
        
    def _writeExpNormalizeOption(self, fileName):
        f = open(fileName, 'w')
        f.write("chr1\tS-MART\tmatch\t6155418\t6155418\t24\t+\t.\toccurrence=1;rank=1;bestRegion=(self);nbGaps=0;nbOccurrences=1;nbMismatches=0;ID=test1/1;identity=100;Name=test1/1\n")
        f.write("chr2\tS-MART\tmatch\t26303950\t26303950\t32\t+\t.\toccurrence=1;rank=1;bestRegion=(self);nbGaps=0;nbOccurrences=3;nbMismatches=2;ID=test2/1-1;identity=93;Name=test2/1\n")
        f.write("chr3\tS-MART\tmatch\t28320540\t28320540\t35\t+\t.\toccurrence=2;bestRegion=chr2:26303950-26303981;nbGaps=0;nbOccurrences=3;nbMismatches=2;ID=test2/1-2;identity=94;Name=test2/1\n")
        f.write("chr4\tS-MART\tmatch\t28565007\t28565007\t35\t+\t.\toccurrence=3;rank=3;bestRegion=chr2:26303950-26303981;nbGaps=0;nbOccurrences=3;nbMismatches=4;ID=test2/1-3;identity=88;Name=test2/1\n")
        f.close()
        
    def _writeExpDistance_option(self, fileName):
        f = open(fileName, 'w')
        f.write("chr1\tS-MART\tmatch\t6155418\t6155418\t24\t+\t.\toccurrence=1;rank=1;bestRegion=(self);nbGaps=0;nbOccurrences=1;nbMismatches=0;ID=test1/1;identity=100;Name=test1/1\n")
        f.write("chr2\tS-MART\tmatch\t26303950\t26303950\t32\t+\t.\toccurrence=1;rank=1;bestRegion=(self);nbGaps=0;nbOccurrences=3;nbMismatches=2;ID=test2/1-1;identity=93;Name=test2/1\n")
        f.write("chr3\tS-MART\tmatch\t28320540\t28320540\t35\t+\t.\toccurrence=2;bestRegion=chr2:26303950-26303981;nbGaps=0;nbOccurrences=3;nbMismatches=2;ID=test2/1-2;identity=94;Name=test2/1\n")
        f.write("chr4\tS-MART\tmatch\t28565007\t28565007\t35\t+\t.\toccurrence=3;rank=3;bestRegion=chr2:26303950-26303981;nbGaps=0;nbOccurrences=3;nbMismatches=4;ID=test2/1-3;identity=88;Name=test2/1\n")
        f.close()
        
    def _writeExpColinearOption(self, fileName):
        f = open(fileName, 'w')
        f.write("chr1\tS-MART\tmatch\t6155418\t6155418\t24\t+\t.\toccurrence=1;rank=1;bestRegion=(self);nbGaps=0;nbOccurrences=1;nbMismatches=0;ID=test1/1;identity=100;Name=test1/1\n")
        f.write("chr2\tS-MART\tmatch\t26303950\t26303950\t32\t+\t.\toccurrence=1;rank=1;bestRegion=(self);nbGaps=0;nbOccurrences=3;nbMismatches=2;ID=test2/1-1;identity=93;Name=test2/1\n")
        f.write("chr3\tS-MART\tmatch\t28320540\t28320540\t35\t+\t.\toccurrence=2;bestRegion=chr2:26303950-26303981;nbGaps=0;nbOccurrences=3;nbMismatches=2;ID=test2/1-2;identity=94;Name=test2/1\n")
        f.write("chr4\tS-MART\tmatch\t28565007\t28565007\t35\t+\t.\toccurrence=3;rank=3;bestRegion=chr2:26303950-26303981;nbGaps=0;nbOccurrences=3;nbMismatches=4;ID=test2/1-3;identity=88;Name=test2/1\n")
        f.close()
        
    def _writeExpExcelOption(self, fileName):
        f = open(fileName, 'w')
        f.write("chr1\tS-MART\tmatch\t6155418\t6155418\t24\t+\t.\toccurrence=1;rank=1;bestRegion=(self);nbGaps=0;nbOccurrences=1;nbMismatches=0;ID=test1/1;identity=100;Name=test1/1\n")
        f.write("chr2\tS-MART\tmatch\t26303950\t26303950\t32\t+\t.\toccurrence=1;rank=1;bestRegion=(self);nbGaps=0;nbOccurrences=3;nbMismatches=2;ID=test2/1-1;identity=93;Name=test2/1\n")
        f.write("chr3\tS-MART\tmatch\t28320540\t28320540\t35\t+\t.\toccurrence=2;bestRegion=chr2:26303950-26303981;nbGaps=0;nbOccurrences=3;nbMismatches=2;ID=test2/1-2;identity=94;Name=test2/1\n")
        f.write("chr4\tS-MART\tmatch\t28565007\t28565007\t35\t+\t.\toccurrence=3;rank=3;bestRegion=chr2:26303950-26303981;nbGaps=0;nbOccurrences=3;nbMismatches=4;ID=test2/1-3;identity=88;Name=test2/1\n")
        f.close()
        
if __name__ == "__main__":
    unittest.main()
