#! /usr/bin/env python
#
# Copyright INRA-URGI 2009-2010
# 
# This software is governed by the CeCILL license under French law and
# abiding by the rules of distribution of free software. You can use,
# modify and/ or redistribute the software under the terms of the CeCILL
# license as circulated by CEA, CNRS and INRIA at the following URL
# "http://www.cecill.info".
# 
# As a counterpart to the access to the source code and rights to copy,
# modify and redistribute granted by the license, users are provided only
# with a limited warranty and the software's author, the holder of the
# economic rights, and the successive licensors have only limited
# liability.
# 
# In this respect, the user's attention is drawn to the risks associated
# with loading, using, modifying and/or developing or reproducing the
# software by the user in light of its specific status of free software,
# that may mean that it is complicated to manipulate, and that also
# therefore means that it is reserved for developers and experienced
# professionals having in-depth computer knowledge. Users are therefore
# encouraged to load and test the software's suitability as regards their
# requirements in conditions enabling the security of their systems and/or
# data to be ensured and, more generally, to use and operate it in the
# same conditions as regards security.
# 
# The fact that you are presently reading this means that you have had
# knowledge of the CeCILL license and that you accept its terms.
#
"""Update a .qual file given a .fasta file"""

from optparse import OptionParser
from commons.core.parsing.FastaParser import *
from SMART.Java.Python.misc.Progress import *


if __name__ == "__main__":
    
    # parse command line
    description = "Update Qual v1.0.1: Remove the sequence in a Qual file which are not in the corresponding Fasta file. [Category: Personnal]"

    parser = OptionParser(description = description)
    parser.add_option("-f", "--fasta",         dest="fastaFile",    action="store",                                         type="string", help="fasta file [compulsory] [format: file in FASTA format]")
    parser.add_option("-q", "--qual",            dest="qualFile",     action="store",                                         type="string", help="qual file [compulsory] [format: file in QUAL format]")
    parser.add_option("-o", "--output",        dest="outputFile", action="store",                                         type="string", help="output file [compulsory] [format: output file in QUAL format]")
    parser.add_option("-v", "--verbosity", dest="verbosity",    action="store",            default=1,         type="int",        help="trace level [format: int]")
    (options, args) = parser.parse_args()

    parser             = SequenceListParser(options.fastaFile, options.verbosity)
    nbSequences    = parser.getNbSequences()
    progress         = Progress(nbSequences, "Parsing file %s" % (options.fastaFile), options.verbosity)
    qualHandle     = open(options.qualFile)
    outputHandle = open(options.outputFile, "w")
    nbRefused        = 0
    nbTotal            = 0
    
    names = []
    while parser.getNextSequence():
        sequence = parser.getCurrentSequence()
        nbTotal += 1
    
        found = False
        name    = None
        for line in qualHandle:
            line = line.strip()
            if line[0] == ">":
                name = line[1:]
                if name == sequence.name:
                    found = True
                else:
                    nbRefused += 1
            else:
                if found:
                    outputHandle.write(">%s\n%s\n" % (name, line))
                    found = False
                    name    = None
                    break
        progress.inc()
    progress.done()

    
    outputHandle.close()
    qualHandle.close()
    
    print "%d out of %d are refused (%f%%)"             % (nbRefused, nbTotal, (float(nbRefused) / nbTotal * 100))        
