import unittest
from parser.gffParser import *


class TestGffParser(unittest.TestCase):
  
  def setUp(self):
    pass   

  def tearDown(self):
    pass


  def testParser(self):
    parser = GffParser("TestFiles/testGffParser1.gff3")

    self.assertEqual(parser.getNbTranscripts(), 3)

    cpt = 0
    for transcript in parser.getIterator():
      cpt += 1
      if cpt == 1:
        self.assertEqual(transcript.chromosome, "arm_X")
        self.assertEqual(transcript.name, "test1")
        self.assertEqual(transcript.start, 1000)
        self.assertEqual(transcript.end, 2000)
        self.assertEqual(transcript.direction, 1)
        self.assertEqual(transcript.getNbExons(), 1)
        self.assertEqual(transcript.getTagValue("field"), "value1")
        exons = transcript.getExons()
        self.assertEqual(exons[0].chromosome, "arm_X")
        self.assertEqual(exons[0].start, 1000)
        self.assertEqual(exons[0].end, 2000)
        self.assertEqual(exons[0].direction, 1)
        self.assertEqual(transcript.getSize(), 1001)
      elif cpt == 2:
        self.assertEqual(transcript.chromosome, "arm_X")
        self.assertEqual(transcript.name, "test2")
        self.assertEqual(transcript.start, 10000)
        self.assertEqual(transcript.end, 20000)
        self.assertEqual(transcript.direction, -1)
        self.assertEqual(transcript.getNbExons(), 2)
        self.assertEqual(transcript.getTagValue("field"), "value2")
        exons = transcript.getExons()
        self.assertEqual(exons[0].chromosome, "arm_X")
        self.assertEqual(exons[0].start, 10000)
        self.assertEqual(exons[0].end, 10100)
        self.assertEqual(exons[0].direction, -1)
        self.assertEqual(exons[1].chromosome, "arm_X")
        self.assertEqual(exons[1].start, 10500)
        self.assertEqual(exons[1].end, 20000)
        self.assertEqual(exons[1].direction, -1)
        self.assertEqual(transcript.getSize(), 9602)
      if cpt == 3:
        self.assertEqual(transcript.chromosome, "arm_X")
        self.assertEqual(transcript.name, "test1.1")
        self.assertEqual(transcript.start, 1000)
        self.assertEqual(transcript.end, 2000)
        self.assertEqual(transcript.direction, 1)
        self.assertEqual(transcript.getNbExons(), 1)
        self.assertEqual(transcript.getTagValue("ID"), "test1.1-1")
        exons = transcript.getExons()
        self.assertEqual(exons[0].chromosome, "arm_X")
        self.assertEqual(exons[0].start, 1000)
        self.assertEqual(exons[0].end, 2000)
        self.assertEqual(exons[0].direction, 1)
        self.assertEqual(transcript.getSize(), 1001)


if __name__ == '__main__':
    unittest.main()

