import sys
import re

reverseComplementString = {
  "A": "T",
  "C": "G",
  "G": "C",
  "T": "A",
  "U": "A",
  "N": "N",
  "a": "t",
  "c": "g",
  "g": "c",
  "t": "a",
  "u": "a",
  "n": "n"
}


class Sequence(object):
  """A class that codes for a sequence"""

  def __init__(self, name = "", sequence = ""):
    self.name            = name
    self.sequence        = sequence
    self.quality         = None
    self.chunkedSequence = None
    self.chunkedQuality  = None


  def getSize(self):
    return len(self.sequence)


  def chunkSequence(self):
    self.chunkedSequence = []
    for i in range (0, self.getSize() / 60 + 1):
      self.chunkedSequence.append(self.sequence[i * 60 : min(self.getSize(), (i+1) * 60)])
    if self.quality != None:
      self.chunkedQuality = []
      for i in range (0, self.getSize() / 60 + 1):
        self.chunkedQuality.append(self.quality[i * 60 : min(self.getSize(), (i+1) * 60)])


  def concatenate(self, sequence):
    self.sequence += sequence.sequence
    if self.quality != None:
      self.quality += sequence.quality
    self.chunkedSequence = None
    self.chunkedQuality  = None
    

  def printFasta(self):
    if self.chunkedSequence == None:
      self.chunkSequence()
    return ">%s\n%s\n" % (self.name, "\n".join(self.chunkedSequence))


  def printFastq(self):
    if self.chunkedSequence == None:
      self.chunkSequence()
    return "@%s\n%s\n+%s\n%s\n" % (self.name, "\n".join(self.chunkedSequence), self.name, "\n".join(self.chunkedQuality))


  def reverseComplement(self):
    sequence = ""

    self.chunkedSequence = None
    self.chunkedQuality  = None
    for i in range(0, self.getSize()):
      char = self.sequence[i:i+1]
      if char not in reverseComplementString:
        sys.exit("Cannot understand character %s from string %s" % (char, self.sequence))
      sequence = "%s%s" % (reverseComplementString[char], sequence)
    self.sequence = sequence
    if self.quality != None:
      self.quality  = self.quality[::-1]
    
    
  def containsAmbiguousNucleotides(self):
    m = re.search(r"[^ACGTUacgtu]", self.sequence)
    if m != None:
      return True
    return False
  
  
  def shrinkToFirstNucleotides(self, nbNucleotides):
    self.chunkedSequence = None
    self.chunkedQuality  = None
    self.sequence        = self.sequence[0:nbNucleotides]
    if self.quality != None:
      self.quality = self.quality[0:nbNucleotides]
  
  
  def shrinkToLastNucleotides(self, nbNucleotides):
    self.chunkedSequence = None
    self.chunkedQuality  = None
    self.sequence        = self.sequence[-nbNucleotides:]
    if self.quality != None:
      self.quality = self.quality[-nbNucleotides:]
