#! /usr/bin/env python
import sys
import MySQLdb
from mySql.mySqlTable import *


class MySqlQuery(object):
  """Query to a database"""

  def __init__(self, user, host, password, databaseName, verbosity = 0):
    self.verbosity  = verbosity
    try:
      self.db = MySQLdb.connect(host = host, user = user, passwd = password, db = databaseName, local_infile = 1)
    except:
      sys.stderr.write("Problem to connect, trying once again...\n")
      self.db = MySQLdb.connect(host = host, user = user, passwd = password, db = databaseName)
    self.cursor     = self.db.cursor()
    self.insertedId = None
    
    
  def __del__(self):
    self.close()


  def close(self):
    self.db.close()


  def execute(self, query, insertion = False):
    if self.verbosity > 99:
      print "Querying %s" % (query)
    results = self.cursor.execute(query)
    if insertion:
      self.cursor.execute("SELECT LAST_INSERT_ID()")
      self.insertedId = self.getLine()[0]
    else:
      self.insertedId = None
    return results


  def getLine(self):
    return self.cursor.fetchone()


  def getLines(self):
    return self.cursor.fetchall()


  def isEmpty(self):
     self.getLines()
     return self.cursor.rowcount == None or self.cursor.rowcount == 0
  

  def getInsertedId(self):
    return self.insertedId


  def getIterator(self):
    line = self.getLine()
    while line != None:
      yield line
      line = self.getLine()
     

  def show(self):
    for line in self.getIterator():
      print line
