#! /usr/bin/env python
#
# Copyright INRA-URGI 2009-2012
# 
# This software is governed by the CeCILL license under French law and
# abiding by the rules of distribution of free software. You can use,
# modify and/ or redistribute the software under the terms of the CeCILL
# license as circulated by CEA, CNRS and INRIA at the following URL
# "http://www.cecill.info".
# 
# As a counterpart to the access to the source code and rights to copy,
# modify and redistribute granted by the license, users are provided only
# with a limited warranty and the software's author, the holder of the
# economic rights, and the successive licensors have only limited
# liability.
# 
# In this respect, the user's attention is drawn to the risks associated
# with loading, using, modifying and/or developing or reproducing the
# software by the user in light of its specific status of free software,
# that may mean that it is complicated to manipulate, and that also
# therefore means that it is reserved for developers and experienced
# professionals having in-depth computer knowledge. Users are therefore
# encouraged to load and test the software's suitability as regards their
# requirements in conditions enabling the security of their systems and/or
# data to be ensured and, more generally, to use and operate it in the
# same conditions as regards security.
# 
# The fact that you are presently reading this means that you have had
# knowledge of the CeCILL license and that you accept its terms.
#

import random, os, time
from optparse import OptionParser
from commons.core.parsing.ParserChooser import ParserChooser
from SMART.Java.Python.structure.Transcript import Transcript
from SMART.Java.Python.structure.Interval import Interval
from SMART.Java.Python.ncList.NCList import NCList
from SMART.Java.Python.ncList.NCListCursor import NCListCursor
try:
   import cPickle as pickle
except:
   import pickle

class NCListParser(object):
    
    def __init__(self, fileName, verbosity = 1):
        self._fileName                = fileName
        self._ncLists                 = {}
        self._sortedFileNames         = {}
        self._nbElements              = 0
        self._nbElementsPerChromosome = {}
        self._verbosity               = verbosity
        
    def parse(self):
        handle                        = open(self._fileName)
        self._sortedFileNames         = pickle.load(handle)
        self._nbElements              = pickle.load(handle)
        self._nbElementsPerChromosome = pickle.load(handle)
        self._ncLists                 = pickle.load(handle)
        for ncList in self._ncLists.values():
            ncList._reopenFiles()
        handle.close()

    def getSortedFileNames(self):
        return self._sortedFileNames

    def getNbElements(self):
        return self._nbElements

    def getNbElementsPerChromosome(self):
        return self._nbElementsPerChromosome

    def getNCLists(self):
        return self._ncLists
