import os
import sys
import unittest
from SMART.Java.Python.test.MockGetLetterDistribution import MockGetLetterDistributionFasta
from SMART.Java.Python.test.MockGetLetterDistribution import MockGetLetterDistributionFastq
from SMART.Java.Python.test.MockGetLetterDistribution import MockGetLetterDistributionExpectedCSV

class Test_F_getLetterDistribution(unittest.TestCase):
	
	def tearDown(self):
		os.system("rm tmp*.*")

	def test_getLetterDistributionWithFasta(self):
		iFastaMock = MockGetLetterDistributionFasta()
		fastaFileName = "MockFasta_GetLetterDistribution.fa"
		iFastaMock.write(fastaFileName)

		outputName = "dummy_result_fasta"		
		os.system("python %s/SMART/Java/Python/getLetterDistribution.py -i %s -f fasta -o %s" % (os.environ["REPET_PATH"], fastaFileName, outputName))

		self.assertTrue (os.path.exists(outputName + ".png"))
		self.assertTrue (os.path.exists(outputName + "PerNt.png"))

		os.remove(outputName + ".png")
		os.remove(outputName + "PerNt.png")
		os.remove(fastaFileName)

	def test_getLetterDistributionWithFastq(self):
		iFastqMock = MockGetLetterDistributionFastq()
		fastqFileName = "MockFastq_GetLetterDistribution.fastq"
		iFastqMock.write(fastqFileName)

		outputName = "dummy_result_fastq"		
		os.system("python %s/SMART/Java/Python/getLetterDistribution.py -i %s -f fastq -o %s" % (os.environ["REPET_PATH"], fastqFileName, outputName))

		self.assertTrue (os.path.exists(outputName + ".png"))
		self.assertTrue (os.path.exists(outputName + "PerNt.png"))

		os.remove(fastqFileName)
		os.remove(outputName + ".png")
		os.remove(outputName + "PerNt.png")

	def test_getLetterDistributionWithFastaCSVOutput(self):
		iFastaMock = MockGetLetterDistributionFasta()
		fastaFileName = "MockFasta_GetLetterDistribution.fa"
		iFastaMock.write(fastaFileName)

		iCSVMock = MockGetLetterDistributionExpectedCSV()
		expCSVFileName = "expCSV.csv"
		iCSVMock.write(expCSVFileName)	

		outputName = "dummy_result_fasta"		
		os.system("python %s/SMART/Java/Python/getLetterDistribution.py -i %s -f fasta -o %s -c" % (os.environ["REPET_PATH"], fastaFileName, outputName))

		obsCSVFileName = outputName + ".csv"

		self.assertTrue (os.path.exists(outputName + ".png"))
		self.assertTrue (os.path.exists(outputName + "PerNt.png"))
		self.assertTrue (self._are2FilesIdentical(expCSVFileName, obsCSVFileName))

		os.remove(outputName + ".png")
		os.remove(outputName + "PerNt.png")
		os.remove(fastaFileName)
		os.remove(expCSVFileName)
		os.remove(obsCSVFileName)
	
	def test_getLetterDistributionWithFastqCVSOutput(self):
		iFastqMock = MockGetLetterDistributionFastq()
		fastqFileName = "MockFastq_GetLetterDistribution.fastq"
		iFastqMock.write(fastqFileName)

		iCSVMock = MockGetLetterDistributionExpectedCSV()
		expCSVFileName = "expCSV.csv"
		iCSVMock.write(expCSVFileName)	

		outputName = "dummy_result_fastq"		
		os.system("python %s/SMART/Java/Python/getLetterDistribution.py -i %s -f fastq -o %s -c" % (os.environ["REPET_PATH"], fastqFileName, outputName))

		obsCSVFileName = outputName + ".csv"

		self.assertTrue (os.path.exists(outputName + ".png"))
		self.assertTrue (os.path.exists(outputName + "PerNt.png"))
		self.assertTrue (self._are2FilesIdentical(expCSVFileName, obsCSVFileName))

		os.remove(fastqFileName)
		os.remove(outputName + ".png")
		os.remove(outputName + "PerNt.png")
		os.remove(expCSVFileName)
		os.remove(obsCSVFileName)

	def _are2FilesIdentical(self, file1, file2 ):
		tmpFile = "diff_%s_%s" % ( os.path.basename(file1), os.path.basename(file2) )
		cmd = "diff %s %s >> %s" % ( file1, file2, tmpFile )
		returnStatus = os.system( cmd )
		if returnStatus != 0:
			msg = "ERROR: 'diff' returned '%i'" % ( returnStatus )
			sys.stderr.write( "%s\n" % msg )
			sys.stderr.flush()
			os.remove( tmpFile )
			return False
		if self.isEmpty( tmpFile ):
			os.remove( tmpFile )
			return True
		else:
			os.remove( tmpFile )
			return False

	def getNbLinesInSingleFile(self, fileName):
		fileHandler = open(fileName, "r" )
		lines = fileHandler.readlines()
		fileHandler.close()
		return len(lines)

	def isEmpty(self, fileName):
		return 0 == self.getNbLinesInSingleFile( fileName )

if __name__ == "__main__":
	unittest.main()
