# Copyright INRA (Institut National de la Recherche Agronomique)
# http://www.inra.fr
# http://urgi.versailles.inra.fr
#
# This software is governed by the CeCILL license under French law and
# abiding by the rules of distribution of free software.  You can  use, 
# modify and/ or redistribute the software under the terms of the CeCILL
# license as circulated by CEA, CNRS and INRIA at the following URL
# "http://www.cecill.info". 
#
# As a counterpart to the access to the source code and  rights to copy,
# modify and redistribute granted by the license, users are provided only
# with a limited warranty  and the software's author,  the holder of the
# economic rights,  and the successive licensors  have only  limited
# liability. 
#
# In this respect, the user's attention is drawn to the risks associated
# with loading,  using,  modifying and/or developing or reproducing the
# software by the user in light of its specific status of free software,
# that may mean  that it is complicated to manipulate,  and  that  also
# therefore means  that it is reserved for developers  and  experienced
# professionals having in-depth computer knowledge. Users are therefore
# encouraged to load and test the software's suitability as regards their
# requirements in conditions enabling the security of their systems and/or 
# data to be ensured and,  more generally, to use and operate it in the 
# same conditions as regards security. 
#
# The fact that you are presently reading this means that you have had
# knowledge of the CeCILL license and that you accept its terms.


from commons.core.checker.CheckerException import CheckerException
from commons.core.parsing.VarscanHit_v2_2_8 import VarscanHit_v2_2_8
from commons.core.parsing.VarscanHit_WithTag import VarscanHit_WithTag

class VarscanHit_v2_2_8_WithTag(VarscanHit_v2_2_8):
    
    def __init__(self, chrom = "", position = "", ref = "", cns = "", readsRef = "", readsVar = "", varFreq = "", strandsRef = "", strandsVar = "", qualRef = "", qualVar = "", pValue = "", mapQualRef = "", mapQualVar = "", readsRefPlus = "", readsRefMinus = "", readsVarPlus = "", readsVarMinus = "", var = "", tag = ""):
        self._tag = tag
        VarscanHit_v2_2_8.__init__(self, chrom, position, ref, var, readsRef, readsVar, varFreq, strandsRef, strandsVar, qualRef, qualVar, pValue, mapQualRef, mapQualVar, readsRefPlus, readsRefMinus, readsVarPlus, readsVarMinus, var)
        
    def __eq__(self, o):
        if self._tag == o._tag:
            return VarscanHit_v2_2_8.__eq__(self, o)
        return False
    
    def setTag(self, tag):
        self._tag = tag
        
    def getTag(self):
        return self._tag
    
    def getHeader(self):
        return "Chrom\tPosition\tRef\tCons\tReads1\tReads2\tVarFreq\tStrands1\tStrands2\tQual1\tQual2\tPvalue\tMapQual1\tMapQual2\tReads1Plus\tReads1Minus\tReads2Plus\tReads2Minus\tVarAllele\tTag\n"
    
    def getVarscanLine(self):
        return "%s\t%s\t%s\t%s\t%s\t%s\t%s\t%s\t%s\t%s\t%s\t%s\t%s\t%s\t%s\t%s\t%s\t%s\t%s\t%s\n" % (self.getChrom(), self.getPosition(), self.getRef(), self.getCns(), self.getReadsRef(), self.getReadsVar(), self.getVarFreq(), self.getStrandsRef(), self.getStrandsVar(),  self.getQualRef(), self.getQualVar(), self.getPValue(), self.getMapQualRef(), self.getMapQualVar(), self.getReadsRefPlus(), self.getReadsRefMinus(), self.getReadsVarPlus(), self.getReadsVarMinus(), self.getVar(), self.getTag())
    
    def setAttributes(self, lResults, iCurrentLineNumber):
        VarscanHit_v2_2_8.setAttributes(self, lResults, iCurrentLineNumber)
        if lResults[19] != '':
            self.setTag(lResults[19])
        else:
            raise CheckerException ("The field tag is empty in varscan file in line %s" % iCurrentLineNumber)
            
    def setAttributesFromString(self, varscanString, iCurrentLineNumber ="", fieldSeparator ="\t"):
        varscanString = varscanString.rstrip()
        lvarscanStringItem = varscanString.split(fieldSeparator)
        if len(lvarscanStringItem) < 20:
            raise CheckerException ("This varscan line (l.%s) is not complete" % iCurrentLineNumber)
        self.setAttributes(lvarscanStringItem, iCurrentLineNumber)
        
    def convertVarscanHit_v2_2_8_WithTag_To_VarscanHit_WithTag(self):
        iVarscanHit = VarscanHit_WithTag()
        iVarscanHit.setChrom(self.getChrom())
        iVarscanHit.setPosition(self.getPosition())
        iVarscanHit.setRef(self.getRef())
        iVarscanHit.setVar(self.getVar())
        iVarscanHit.setReadsRef(self.getReadsRef())
        iVarscanHit.setReadsVar(self.getReadsVar())
        iVarscanHit.setVarFreq(self.getVarFreq())
        iVarscanHit.setStrandsRef(self.getStrandsRef())
        iVarscanHit.setStrandsVar(self.getStrandsVar())
        iVarscanHit.setQualRef(self.getQualRef())
        iVarscanHit.setQualVar(self.getQualVar())
        iVarscanHit.setPValue(self.getPValue())
        iVarscanHit.setTag(self.getTag())
        return iVarscanHit