#! /usr/bin/env python
"""Convert a FASTQ file to a FASTA file"""

import os
from optparse import OptionParser
from parsing.bedParser import *
from parsing.axtParser import *
from misc.rPlotter import *
from misc.progress import *
from math import *

if __name__ == "__main__":
  
  # parse command line
  description = "FastQ to FastA: Convert a FastQ file into a FastA file. [Category: Personnal]"

  parser = OptionParser(description = description)
  parser.add_option("-i", "--input",      dest="inputFileName",     action="store",                        type="string", help="input file [compulsory] [format: file in FASTQ format]")
  parser.add_option("-o", "--output",     dest="outputFileName",    action="store",                        type="string", help="output file [compulsory] [format: output file in FASTA format]")
  parser.add_option("-v", "--verbosity",  dest="verbosity",         action="store",      default=1,        type="int",    help="trace level [default: 1] [format: int]")
  (options, args) = parser.parse_args()

  inputFile       = open(options.inputFileName)
  outputFastaFile = open(options.outputFileName, "w")
  
  inSequenceName = False
  inQualityName  = False
  inSequence     = False
  inQuality      = True
  sequenceName   = None
  lineNumber     = 1
  
  for line in inputFile:

    if inSequenceName:
      inSequence     = True
      inSequenceName = False
    elif inQualityName:
      inQuality     = True
      inQualityName = False
    elif inSequence:
      inQualityName = True
      inSequence    = False
    elif inQuality:
      inSequenceName = True
      inQuality      = False
    else:
      sys.exit("Error! Do not in which section I am (line is %d)" % (lineNumber))

    line = line.strip()
    if inSequenceName:
      if line[0] != "@":
        sys.exit("Error! Sequence name '%s' does not start with '@' (line is %d)" % (line, lineNumber))
      sequenceName = line[1:]
      outputFastaFile.write(">%s\n" % (sequenceName))
    elif inQualityName:
      if line[0] != "+":
        sys.exit("Error! Quality name '%s' does not start with '+' (line is %d)" % (line, lineNumber))
      if sequenceName != line[1:]:
        sys.exit("Names in sequence and qual are different (%s, %s) (line is %d)" % (sequenceName, line[1:], lineNumber))
    elif inSequence:
      outputFastaFile.write("%s\n" % (line))
    elif inQuality:
      pass
    lineNumber += 1
  
  inputFile.close()
  outputFastaFile.close()
