import os
import random
from structure.transcript import *
from structure.transcriptList import *
from writer.transcriptListWriter import *


class SamWriter(TranscriptListWriter):
  """
  A class that writes a transcript list into a file with SAM format
  @ivar sizes: estimated sizes of the chromosomes
  @type sizes: dict of string to int
  """


  def __init__(self, fileName, verbosity = 0):
    """
    Constructor
    @param fileName:  name of the file 
    @type fileName:   string
    @param verbosity: verbosity
    @type verbosity:  int
    """
    super(SamWriter, self).__init__(fileName, verbosity)
    self.sizes = {}
    
    
  def __del__(self):
    """
    Destructor (trick to add header)
    """
    super(SamWriter, self).__del__()
    tmpFileName = "tmpFile%d.sam" % (random.randint(0, 100000))
    tmpHandle   = open(tmpFileName, "w")
    for chromosome, size in self.sizes.iteritems():
      tmpHandle.write("@SQ\tSN:%s\tLN:%d\n" % (chromosome, size))
    self.handle = open(self.fileName)
    for line in self.handle:
      tmpHandle.write(line)
    tmpHandle.close()
    self.handle.close()
    os.rename(tmpFileName, self.fileName)


  def printTranscript(self, transcript):
    """
    Export the given transcript with GBrowse format
    @param transcript: transcript to be printed
    @type transcript:  class L{Transcript<Transcript>}
    @return:           a string
    """
    if transcript.chromosome not in self.sizes:
      self.sizes[transcript.chromosome] = transcript.end
    else:
      self.sizes[transcript.chromosome] = max(transcript.end, self.sizes[transcript.chromosome])
    return transcript.printSam()

