/**
 *
 * Copyright INRA-URGI 2009-2010
 * 
 * This software is governed by the CeCILL license under French law and
 * abiding by the rules of distribution of free software. You can use,
 * modify and/ or redistribute the software under the terms of the CeCILL
 * license as circulated by CEA, CNRS and INRIA at the following URL
 * "http://www.cecill.info".
 * 
 * As a counterpart to the access to the source code and rights to copy,
 * modify and redistribute granted by the license, users are provided only
 * with a limited warranty and the software's author, the holder of the
 * economic rights, and the successive licensors have only limited
 * liability.
 * 
 * In this respect, the user's attention is drawn to the risks associated
 * with loading, using, modifying and/or developing or reproducing the
 * software by the user in light of its specific status of free software,
 * that may mean that it is complicated to manipulate, and that also
 * therefore means that it is reserved for developers and experienced
 * professionals having in-depth computer knowledge. Users are therefore
 * encouraged to load and test the software's suitability as regards their
 * requirements in conditions enabling the security of their systems and/or
 * data to be ensured and, more generally, to use and operate it in the
 * same conditions as regards security.
 * 
 * The fact that you are presently reading this means that you have had
 * knowledge of the CeCILL license and that you accept its terms.
 *
 */
import java.util.*;
import java.awt.*;
import javax.swing.*;


public class Program {
  String                 shortName;
  String                 name;
  String                 section;
  String                 description;
  Vector <ProgramOption> options;
  JPanel                 panel;
  JButton                button;


  public Program() {
    this.shortName = null;  
    this.name      = null;  
    this.options   = new Vector <ProgramOption> ();  
  }


  public void setShortName(String shortName) {
    this.shortName = shortName;
  }


  public void setName(String name) {
    this.name = name;
  }


  public void setSection(String section) {
    this.section = section;
  }

  public void setDescription(String description) {
    this.description = description;
  }


  public void addOption(ProgramOption option) {
    options.add(option);
  }


  public String getShortName() {
    return this.shortName;
  }


  public String getName() {
    return this.name;
  }


  public String getSection() {
    return this.section;
  }

  public String getDescription() {
    return this.description;
  }


  public String checkValues() {
    for (int i = 0; i < options.size(); i++) {
      String comment = options.get(i).checkValue();
      if (comment != null) {
        return comment;
      }
    }
    return null;
  }


  public LinkedList<String> getCommand() {
    LinkedList<String> parameterList = new LinkedList<String>();
    parameterList.add(Global.pythonCommand);
    parameterList.add("Python" + java.io.File.separator + this.shortName);
    for (int i = 0; i < options.size(); i++) {
      ProgramOption option = options.get(i);
      parameterList.addAll(option.getCommand());
    }
    return parameterList;
  }


  public JPanel getPanel() {
    if (this.panel != null) {
      return this.panel;
    }
    
    this.panel = new JPanel(false);
    this.panel.setLayout(new FlowLayout());
    Box box = Box.createVerticalBox();

    JPanel descriptionPanel = new JPanel(false);
    JLabel descriptionLabel = new JLabel(this.description);
    descriptionPanel.add(descriptionLabel);
    box.add(descriptionPanel);

    for (int i = 0; i < options.size(); i++) {
      ProgramOption option = options.get(i);
      JPanel        panel  = option.getPanel();
      if (panel == null) {
        System.out.println("Problem with Python program '" + this.shortName + "'.");
        return null;
      }
      box.add(option.getPanel());
    }

    JPanel buttonPanel = new JPanel(false);
    this.button = new JButton("GO!");

    buttonPanel.add(button);

    box.add(buttonPanel);

    this.panel.add(box);

    return this.panel;
  }


  public JButton getButton() {
    if (this.button == null) {
      this.getPanel();
    }
    return this.button;
  }

  
  public Vector < File > getOutputFiles() {
    Vector < File > files = new Vector < File > ();
    for (int i = 0; i < options.size(); i++) {
      ProgramOption option = options.get(i);
      if (! option.isInput()) {
        files.add(option.getOutputFile());
      }
    }
    return files;
  }
}
