#
# Copyright INRA-URGI 2009-2010
# 
# This software is governed by the CeCILL license under French law and
# abiding by the rules of distribution of free software. You can use,
# modify and/ or redistribute the software under the terms of the CeCILL
# license as circulated by CEA, CNRS and INRIA at the following URL
# "http://www.cecill.info".
# 
# As a counterpart to the access to the source code and rights to copy,
# modify and redistribute granted by the license, users are provided only
# with a limited warranty and the software's author, the holder of the
# economic rights, and the successive licensors have only limited
# liability.
# 
# In this respect, the user's attention is drawn to the risks associated
# with loading, using, modifying and/or developing or reproducing the
# software by the user in light of its specific status of free software,
# that may mean that it is complicated to manipulate, and that also
# therefore means that it is reserved for developers and experienced
# professionals having in-depth computer knowledge. Users are therefore
# encouraged to load and test the software's suitability as regards their
# requirements in conditions enabling the security of their systems and/or
# data to be ensured and, more generally, to use and operate it in the
# same conditions as regards security.
# 
# The fact that you are presently reading this means that you have had
# knowledge of the CeCILL license and that you accept its terms.
#

class MySqlQuery(object):
    """Query to a database"""

    def __init__(self, cursor, verbosity = 0):
        self.verbosity = verbosity
        self.cursor = cursor
        self.insertedId = None


    def __del__(self):
        self.cursor.close()
        
        
    def execute(self, query, insertion = False):
        if self.verbosity > 99:
            print "Querying %s" % (query)
        try:
            results = self.cursor.execute(query)
        except Exception:
            raise Exception("Error! Command \"%s\" failed!" % (query))
        if insertion:
            return self.cursor.lastrowid
        return results


    def executeFormat(self, query, parameters):
        if self.verbosity > 99:
            print "Querying %s |" % (query),
            for parameter in parameters:
                print parameter,
            print
        results = self.cursor.execute(query, parameters)
        return results


    def getLine(self):
        return self.cursor.fetchone()


    def getLines(self, lines = None):
        if lines == None:
            return self.cursor.fetchall()
        return self.cursor.fetchmany(lines)


    def isEmpty(self):
        self.getLines()
        return self.cursor.rowcount == None or self.cursor.rowcount == 0
    

    def getInsertedId(self):
        return self.insertedId


    def getIterator(self):
        line = self.getLine()
        while line != None:
            yield line
            line = self.getLine()
         

    def show(self):
        for line in self.getIterator():
            print line
