/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.border.TitledBorder;

public class Smart
extends JPanel
implements ActionListener {
    String version = "1.0.6";
    JFrame mainFrame;
    JButton openButton;
    JButton comparisonGoButton;
    JComboBox formatTypes;
    JComboBox fileFormats;
    String[] emptyFormats = new String[]{"Choose a type first..."};
    JFrame askFrame;
    JButton pythonButton;
    JButton mySqlButton;
    JButton rButton;
    HashMap<JButton, Program> callingProgram = new HashMap();
    JList comparisonFile1List;
    JList comparisonFile2List;
    JTextField comparisonOutputTextField;
    JTextField comparisonFiveQueryExtensionTextField;
    JCheckBox comparisonColinearCheckBox;
    JCheckBox comparisonAntisenseCheckBox;
    JCheckBox comparisonInvertCheckBox;
    JList fileList;
    JTextArea logArea;
    JLabel messageField;
    JProgressBar progressBar;
    JLabel etaField;
    Program currentProgram;
    Process process;
    Timer processTimer = new Timer(1000, this);
    int previousStatus = -1;

    public Smart() {
        super(new BorderLayout());
        this.processTimer.stop();
        this.pythonButton = new JButton("find...");
        this.mySqlButton = new JButton("find...");
        this.rButton = new JButton("find...");
        FormatsReader formatsReader = new FormatsReader(Global.smartFormatsFileName);
        if (!formatsReader.read()) {
            System.out.println("Something was wrong while reading file format...");
        }
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.logArea = new JTextArea(512, Global.logAreaSize);
        this.logArea.setPreferredSize(new Dimension(dimension.width, (int)((double)dimension.height * 0.22)));
        this.logArea.setFont(new Font("Monospaced", this.logArea.getFont().getStyle(), this.logArea.getFont().getSize()));
        JScrollPane jScrollPane = new JScrollPane(this.logArea, 22, 30);
        TitledBorder titledBorder = BorderFactory.createTitledBorder("Log");
        jScrollPane.setBorder(titledBorder);
        this.logArea.append("Using S-MART " + this.version + "\n");
        GridLayout gridLayout = new GridLayout(1, 0);
        this.readConfigurationFile();
        this.checkConfiguration();
        JTabbedPane jTabbedPane = new JTabbedPane();
        jTabbedPane.setPreferredSize(new Dimension(dimension.width, (int)((double)dimension.height * 0.75)));
        JPanel jPanel = new JPanel(false);
        jPanel.setLayout(new FlowLayout());
        jTabbedPane.add("Files", jPanel);
        JPanel jPanel2 = new JPanel(false);
        JPanel jPanel3 = new JPanel(false);
        Vector<String> vector = Global.formats.getFormatTypes();
        jPanel3.setLayout(gridLayout);
        vector.insertElementAt("Choose the format type", 0);
        JLabel jLabel = new JLabel("Format");
        this.formatTypes = new JComboBox<String>(vector);
        this.fileFormats = new JComboBox<String>(this.emptyFormats);
        jLabel.setLabelFor(this.fileFormats);
        this.formatTypes.addActionListener(this);
        jPanel2.add(this.formatTypes);
        jPanel2.add(this.fileFormats);
        jPanel3.add(jLabel);
        jPanel3.add(jPanel2);
        JPanel jPanel4 = new JPanel(false);
        jPanel4.setLayout(gridLayout);
        JLabel jLabel2 = new JLabel("File");
        this.openButton = new JButton("Open a File...");
        this.openButton.addActionListener(this);
        jPanel4.add(jLabel2);
        jPanel4.add(this.openButton);
        JPanel jPanel5 = new JPanel(false);
        jPanel5.setLayout(gridLayout);
        jPanel5.setMinimumSize(new Dimension(10000, 10000));
        JLabel jLabel3 = new JLabel("Existing files");
        Box box = Box.createHorizontalBox();
        box.add(Box.createRigidArea(new Dimension(0, 100)));
        JList jList = new JList(Global.fileNames);
        jList.setLayoutOrientation(2);
        jList.setVisibleRowCount(4);
        JScrollPane jScrollPane2 = new JScrollPane(jList);
        box.add(jScrollPane2);
        jPanel5.add(jLabel3);
        jPanel5.add(box);
        Box box2 = Box.createVerticalBox();
        box2.add(jPanel3);
        box2.add(jPanel4);
        box2.add(jPanel5);
        jPanel.add(box2);
        TreeMap<String, JTabbedPane> treeMap = new TreeMap<String, JTabbedPane>();
        PythonProgramFinder pythonProgramFinder = new PythonProgramFinder("Python");
        String string = pythonProgramFinder.findPrograms();
        if (string != null) {
            this.logArea.append(string);
        }
        for (int i = 0; i < pythonProgramFinder.getPrograms().size(); ++i) {
            Program program = pythonProgramFinder.getPrograms().get(i);
            JPanel jPanel6 = program.getPanel();
            String string2 = program.getSection();
            JTabbedPane jTabbedPane2 = null;
            if (treeMap.containsKey(string2)) {
                jTabbedPane2 = (JTabbedPane)treeMap.get(string2);
            } else {
                jTabbedPane2 = new JTabbedPane();
                jTabbedPane.addTab(string2, jTabbedPane2);
                treeMap.put(string2, jTabbedPane2);
            }
            JScrollPane jScrollPane3 = new JScrollPane(jPanel6, 22, 30);
            jTabbedPane2.addTab(program.getName(), jScrollPane3);
            JButton jButton = program.getButton();
            jButton.addActionListener(this);
            this.callingProgram.put(jButton, program);
        }
        JPanel jPanel7 = new JPanel(new GridLayout(1, 0), false);
        jPanel7.setPreferredSize(new Dimension(dimension.width, (int)((double)dimension.height * 0.02)));
        this.messageField = new JLabel();
        this.progressBar = new JProgressBar(0, 100);
        this.etaField = new JLabel();
        this.messageField.setHorizontalAlignment(2);
        this.progressBar.setValue(0);
        this.etaField.setHorizontalAlignment(4);
        this.progressBar.setStringPainted(true);
        jPanel7.add(this.messageField);
        jPanel7.add(this.progressBar);
        jPanel7.add(this.etaField);
        this.add((Component)jTabbedPane, "First");
        this.add((Component)jScrollPane, "Center");
        this.add((Component)jPanel7, "Last");
    }

    public boolean checkConfiguration() {
        int n = this.testConfiguration();
        if (n == this.previousStatus) {
            this.logArea.append("S-MART does not seem to work properly... Tried to manage it by myself, unsuccessfully... Check documentation for further explanation...\n");
            return false;
        }
        switch (n) {
            case 0: {
                return true;
            }
            case 1: {
                this.logArea.append("S-MART does not seem to work properly... Check documentation for further explanation...\n");
                break;
            }
            case 3: {
                this.askWhereIsProgram("python");
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                this.askWhereIsProgram("mySQL");
                break;
            }
            case 6: {
                this.askWhereIsProgram("R");
                break;
            }
            case 7: {
                this.logArea.append("Please install 'ColorBrewer' R package...\n");
                break;
            }
            default: {
                this.logArea.append("Weird configuration test status: " + n + "...\n");
            }
        }
        this.previousStatus = n;
        return true;
    }

    public int testConfiguration() {
        String[] stringArray = new String[]{Global.pythonCommand, "Python" + java.io.File.separator + "testInstall.py"};
        ProgramLauncher programLauncher = new ProgramLauncher(stringArray, this.logArea, this.messageField, this.progressBar, this.etaField);
        programLauncher.execute();
        return programLauncher.getExitValue();
    }

    public void readConfigurationFile() {
        java.io.File file = new java.io.File(Global.smartConfFileName);
        String string = null;
        if (!file.exists()) {
            return;
        }
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            while ((string = bufferedReader.readLine()) != null) {
                if ((string = string.trim()).startsWith("python:")) {
                    Global.pythonCommand = string.substring("python:".length()).trim();
                    continue;
                }
                if (string.startsWith("mysql:")) {
                    Global.mysqlCommand = string.substring("mysql:".length()).trim();
                    continue;
                }
                if (!string.startsWith("r:")) continue;
                Global.rCommand = string.substring("r:".length()).trim();
            }
            bufferedReader.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.logArea.append("Configuration file is empty: " + fileNotFoundException.getMessage() + "!\n");
            return;
        }
        catch (IOException iOException) {
            this.logArea.append("Weird with configuration file: " + iOException.getMessage() + "!\n");
            return;
        }
    }

    public void askWhereIsProgram(String string) {
        this.askFrame = new JFrame("Where is " + string + "?");
        this.askFrame.setDefaultCloseOperation(3);
        JLabel jLabel = new JLabel("Where is your " + string + " (or " + string + ".exe) file?");
        JButton jButton = null;
        if ("python".equals(string)) {
            jButton = this.pythonButton;
        } else if ("mySQL".equals(string)) {
            jButton = this.mySqlButton;
        } else if ("R".equals(string)) {
            jButton = this.rButton;
        } else {
            this.logArea.append("Problem with the button!\n");
        }
        this.askFrame.getContentPane().add((Component)jLabel, "West");
        this.askFrame.getContentPane().add((Component)jButton, "East");
        jButton.addActionListener(this);
        this.askFrame.pack();
        this.askFrame.setVisible(true);
        this.askFrame.setAlwaysOnTop(true);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.pythonButton) {
            JFileChooser jFileChooser = new JFileChooser();
            if (jFileChooser.showOpenDialog(this.mainFrame) == 0) {
                Global.pythonCommand = jFileChooser.getSelectedFile().getPath();
                this.askFrame.setVisible(false);
                this.askFrame.dispose();
                try {
                    BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(Global.smartConfFileName, true));
                    bufferedWriter.write("python: " + Global.pythonCommand + "\n");
                    bufferedWriter.close();
                }
                catch (IOException iOException) {
                    this.logArea.append("Cannot write configuration file!\n");
                }
            }
            this.checkConfiguration();
        } else if (actionEvent.getSource() == this.mySqlButton) {
            JFileChooser jFileChooser = new JFileChooser();
            if (jFileChooser.showOpenDialog(this.mainFrame) == 0) {
                Global.mysqlCommand = jFileChooser.getSelectedFile().getPath();
                this.askFrame.setVisible(false);
                this.askFrame.dispose();
                try {
                    BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(Global.smartConfFileName, true));
                    bufferedWriter.write("mysql: " + Global.mysqlCommand + "\n");
                    bufferedWriter.close();
                }
                catch (IOException iOException) {
                    this.logArea.append("Cannot write configuration file!\n");
                }
            }
            this.checkConfiguration();
        } else if (actionEvent.getSource() == this.rButton) {
            JFileChooser jFileChooser = new JFileChooser();
            if (jFileChooser.showOpenDialog(this.mainFrame) == 0) {
                Global.rCommand = jFileChooser.getSelectedFile().getPath();
                this.askFrame.setVisible(false);
                this.askFrame.dispose();
                try {
                    BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(Global.smartConfFileName, true));
                    bufferedWriter.write("r: " + Global.rCommand + "\n");
                    bufferedWriter.close();
                }
                catch (IOException iOException) {
                    this.logArea.append("Cannot write configuration file!\n");
                }
            }
            this.checkConfiguration();
        } else if (actionEvent.getSource() == this.formatTypes) {
            this.fileFormats.removeAllItems();
            Vector<String> vector = Global.formats.getFormats((String)this.formatTypes.getSelectedItem()).getFormats();
            for (int i = 0; i < vector.size(); ++i) {
                this.fileFormats.addItem(vector.get(i));
            }
        } else if (actionEvent.getSource() == this.openButton) {
            JFileChooser jFileChooser = new JFileChooser();
            if (jFileChooser.showOpenDialog(this.mainFrame) == 0) {
                String string = jFileChooser.getSelectedFile().getPath();
                Global.fileNames.addElement(string);
                Global.files.addFile(string, (String)this.formatTypes.getSelectedItem(), (String)this.fileFormats.getSelectedItem());
            }
        } else if (Global.otherFilesChooser.containsKey(actionEvent.getSource())) {
            JTextField jTextField = Global.otherFilesChooser.get(actionEvent.getSource());
            JFileChooser jFileChooser = new JFileChooser();
            if (jFileChooser.showOpenDialog(this.mainFrame) == 0) {
                jTextField.setText(jFileChooser.getSelectedFile().getPath());
            }
        } else if (Global.otherDirectoriesChooser.containsKey(actionEvent.getSource())) {
            JTextField jTextField = Global.otherDirectoriesChooser.get(actionEvent.getSource());
            JFileChooser jFileChooser = new JFileChooser();
            jFileChooser.setFileSelectionMode(1);
            if (jFileChooser.showOpenDialog(this.mainFrame) == 0) {
                jTextField.setText(jFileChooser.getSelectedFile().getPath());
            }
        } else if (Global.otherFileConcatenationChooser.containsKey(actionEvent.getSource())) {
            JTextField jTextField = Global.otherDirectoriesChooser.get(actionEvent.getSource());
            JFileChooser jFileChooser = new JFileChooser();
            jFileChooser.setFileSelectionMode(1);
            if (jFileChooser.showOpenDialog(this.mainFrame) == 0) {
                String string = jTextField.getText();
                if (string == null || "".equals(string)) {
                    jTextField.setText(jFileChooser.getSelectedFile().getPath());
                } else {
                    jTextField.setText(string + "," + jFileChooser.getSelectedFile().getPath());
                }
            }
        } else {
            this.currentProgram = this.callingProgram.get(actionEvent.getSource());
            String string = this.currentProgram.checkValues();
            if (string != null) {
                this.logArea.append(string);
                return;
            }
            LinkedList<String> linkedList = this.currentProgram.getCommand();
            ProgramLauncher programLauncher = new ProgramLauncher(linkedList, this.logArea, this.messageField, this.progressBar, this.etaField);
            programLauncher.execute();
            Vector<File> vector = this.currentProgram.getOutputFiles();
            for (int i = 0; i < vector.size(); ++i) {
                File file = vector.get(i);
                if (file.getFormatType().compareToIgnoreCase("other") == 0) continue;
                Global.fileNames.addElement(file.getName());
                Global.files.addFile(file);
            }
            this.currentProgram = null;
        }
    }

    private static void createAndShowGUI() {
        JFrame jFrame = new JFrame("S-Mart");
        jFrame.setDefaultCloseOperation(3);
        Smart smart = new Smart();
        smart.setOpaque(true);
        jFrame.setContentPane(smart);
        jFrame.pack();
        jFrame.setVisible(true);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        jFrame.setBounds(0, 0, dimension.width, dimension.height);
    }

    public static void main(String[] stringArray) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Smart.createAndShowGUI();
            }
        });
    }
}

