#! /usr/bin/env python
"""
Change the name of a tag
"""

import os, random
from optparse import OptionParser
from structure.transcriptContainer import *
from writer.transcriptWriter import *
from misc.progress import *


if __name__ == "__main__":
  
  # parse command line
  description = "Change Tag Name: Change the name of tag of a list of transcripts. [Category: Data Modification]"

  parser = OptionParser(description = description)
  parser.add_option("-i", "--input",        dest="inputFileName",     action="store",                      type="string", help="input file [compulsory] [format: file in transcript format given by -f]")
  parser.add_option("-f", "--inputFormat",  dest="inputFormat",       action="store",                      type="string", help="format of the input file [compulsory] [format: transcript file format]")
  parser.add_option("-o", "--output",       dest="outputFileName",    action="store",                      type="string", help="output file [compulsory] [format: output file in GFF3 format]")
  parser.add_option("-t", "--tag",          dest="tag",               action="store",                      type="string", help="name of the tag to change [compulsory] [format: string]")
  parser.add_option("-n", "--name",         dest="name",              action="store",                      type="string", help="new name for the tag [compulsory] [format: string]")
  parser.add_option("-y", "--mysql",        dest="mysql",             action="store_true", default=False,                 help="mySQL output [format: bool] [default: false]")  
  parser.add_option("-v", "--verbosity",    dest="verbosity",         action="store",      default=1,      type="int",    help="trace level [format: int] [default: 1]")
  parser.add_option("-l", "--log",          dest="log",               action="store_true", default=False,                 help="write a log file [format: bool] [default: false]")
  (options, args) = parser.parse_args()

  if options.log:
    logHandle = open("%s.log" % options.outputFileName, "w")

  # create parser and writer(s)
  parser      = TranscriptContainer(options.inputFileName, options.inputFormat, options.verbosity)
  tmpFileName = "tmpTranscriptFile%d.gff3" % (random.randint(0, 100000))
  writer      = Gff3Writer(tmpFileName, options.verbosity)
  if options.mysql:
    mysqlWriter = MySqlTranscriptWriter(options.outputFileName, options.verbosity)
  outputData = {}
    
  # process transcripts
  progress = Progress(parser.getNbTranscripts(), "Printing transcripts %s" % (options.inputFileName), options.verbosity)
  for transcript in parser.getIterator():
    if options.tag in transcript.tags:
      value = transcript.tags[options.tag]
      del transcript.tags[options.tag]
      transcript.tags[options.name] = value
    writer.addTranscript(transcript)
    if options.mysql:
      mysqlWriter.addTranscript(transcript)
    progress.inc()
  progress.done()
  parser.transcriptListParser.close()

  writer.write()

  if options.mysql:
    mysqlWriter.write()

  os.rename(tmpFileName, "%s.gff3" % (options.outputFileName))
