from structure.transcript import *
from writer.transcriptListWriter import *
from parsing.gbParser import *


class GbWriter(TranscriptListWriter):
  """
  A class that writes a transcript list into a file with GBrowse format
  @ivar fileName: name of the file 
  @type fileName: string
  @ivar handle: handle to the file
  @type handle: file handle
  @ivar header: first lines of the file
  @type header: string
  """


  def __init__(self, fileName, verbosity = 0):
    """
    Constructor
    @param fileName: name of the file 
    @type fileName: string
    @param verbosity: verbosity
    @type verbosity: int
    """
    self.header = "[READS]\nbgcolor = red\nstrand_arrow = 1\n\n"
    super(GbWriter, self).__init__(fileName, verbosity)
   
    
  def setColor(self, color):
    """
    Set the color of the track
    @param color: the color of the track
    @type  color: string
    """
    if color != None:
      self.header = "[READS]\nbgcolor= %s\nstrand_arrow = 1\n\n" % (color)
    
    
  def copyProperties(self, gbParser):
    """
    Copy the properties collected by a parser, to produce a similar output
    @param gbParser: a GBrowse parser
    @type  gbParser: class L{GbParser<GbParser>}
    """
    self.setColor(gbParser.color)
    

  def printTranscript(self, transcript):
    """
    Export the given transcript with GBrowse format
    Possibly skip the reference if already put
    @param transcript: transcript to be printed
    @type transcript: class L{Transcript<Transcript>}
    @return: a string
    """
    if self.lastChromosome != None and self.lastChromosome == transcript.chromosome:
      return transcript.printGBrowseLine()
    return transcript.printGBrowse()
