import re
import math
from structure.sequence import *
from misc.progress import *

class SequenceList(object):
  """A class that codes for a list of sequences"""

  def __init__(self, verbosity = 0):
    self.sequences = []
    self.verbosity = verbosity


  def nbSequences(self):
    return len(self.sequences)


  def getSequence(self, index):
    return self.sequences[index]
    

  def addSequence(self, sequence):
    self.sequences.append(sequence)
    

  def split(self, number):
    sequenceLists = []
    size          = math.ceil(self.nbSequences() / number)

    sequenceList  = SequenceList()
    for i in range(0, self.nbSequences()):
      sequenceList.addSequence(self.getSequence(i))
      if (sequenceList.nbSequences() == size):
        sequenceLists.append(sequenceList)
        sequenceList = SequenceList()
    if (sequenceList.nbSequences() != 0):
      sequenceLists.append(sequenceList)
    return sequenceLists


  def printFasta(self):
    string = ""
    for sequence in self.sequences:
      string += sequence.printFasta()
    return string

