import unittest
import os
from SMART.Java.Python.FindOverlapsOptim import FindOverlapsOptim
from SMART.Java.Python.ncList.NCListCursor import NCListCursor
from SMART.Java.Python.ncList.test.MockFindOverlapsWithSeveralIntervals import *

REFERENCE = 0
QUERY = 1

class Test_FindOverlapsOptim(unittest.TestCase):

    def setUp(self):
        self._inputRefGff3FileName = 'sorted_Ref.gff3'
        self._inputQueryGff3FileName = 'sorted_Query.gff3'
        self._writeQueryGff3File(self._inputQueryGff3FileName)
        self._outputGff3FileName = 'overlaps.gff3'
        iMock = MockFindOverlapsWithServeralIntervals_case1()
        iMock.write(self._inputRefGff3FileName)
        self._iFOO = FindOverlapsOptim(0)
        self._iFOO.setRefFileName(self._inputRefGff3FileName, "gff3")
        self._iFOO.setQueryFileName(self._inputQueryGff3FileName, "gff3")
        self._iFOO.setOutputFileName(self._outputGff3FileName)
        self._iFOO.prepareIntermediateFiles()
        self._iFOO.createNCLists()
        self._queryNcList = self._iFOO._ncLists[QUERY]["chr1"]
        self._refNcList   = self._iFOO._ncLists[REFERENCE]["chr1"]
        
    def tearDown(self):
        os.remove(self._inputRefGff3FileName)
        os.remove(self._inputQueryGff3FileName)
        os.remove(self._outputGff3FileName)
    
    def test_isOverlapping_true(self):
        queryCursor = NCListCursor(None, self._queryNcList, 5, 0)
        refCursor   = NCListCursor(None, self._refNcList,   4, 0)
        obs = self._iFOO.isOverlapping(queryCursor, refCursor)
        exp = 0
        self.assertEquals(exp, obs)
        
    def test_isOverlapping_false_left(self):
        queryCursor = NCListCursor(None, self._queryNcList, 5, 0)
        refCursor   = NCListCursor(None, self._refNcList,   2, 0)
        obs = self._iFOO.isOverlapping(queryCursor, refCursor)
        exp = -1
        self.assertEquals(exp, obs)
    
    def test_isOverlapping_false_right(self):
        queryCursor = NCListCursor(None, self._queryNcList, 5, 0)
        refCursor   = NCListCursor(None, self._refNcList,   1, 0)
        obs = self._iFOO.isOverlapping(queryCursor, refCursor)
        exp = 1
        self.assertEquals(exp, obs) 
           
    def test_isLastElement_true(self):
        refCursor = NCListCursor(None, self._refNcList, 4, 0)
        obsBool   = refCursor.isLast()
        expBool   = True
        self.assertEquals(expBool, obsBool)
    
    def test_isLastElement_false(self):
        refCursor = NCListCursor(None, self._refNcList, 3, 0)
        obsBool   = refCursor.isLast()
        expBool   = False
        self.assertEquals(expBool, obsBool)  
        
    def test_isLastElement_highestLevel_true(self):
        refCursor = NCListCursor(None, self._refNcList, 1, 0)
        obsBool   = refCursor.isLast()
        expBool   = True
        self.assertEquals(expBool, obsBool)
    
    def test_isLastElement_highestLevel_false(self):
        refCursor = NCListCursor(None, self._refNcList, 0, 0)
        obsBool   = refCursor.isLast()
        expBool   = False
        self.assertEquals(expBool, obsBool)           

    def test_findOverlapIter(self):
        queryCursor           = NCListCursor(None, self._queryNcList, 2, 0)
        refCursor             = NCListCursor(None, self._refNcList,   0, 0)
        queryTranscript       = queryCursor.getTranscript()
        done                  = False
        (cursor, done, empty) = self._iFOO.findOverlapIter(queryTranscript, refCursor, done)
        obsFirstOverlapLAddr  = (cursor._lIndex, done, empty)
        expFirstOverlapLAddr  = 4, True, False
        self.assertEquals(expFirstOverlapLAddr, obsFirstOverlapLAddr)
        
    def test_not_findOverlapIter(self):
        queryCursor           = NCListCursor(None, self._queryNcList, 4, 0)
        refCursor             = NCListCursor(None, self._refNcList,   1, 0)
        queryTranscript       = queryCursor.getTranscript()
        done                  = False
        (cursor, done, empty) = self._iFOO.findOverlapIter(queryTranscript, refCursor, done)
        obsFirstOverlapLAddr  = (cursor._lIndex, done, empty)
        expFirstOverlapLAddr  = -1, False, True
        self.assertEquals(expFirstOverlapLAddr, obsFirstOverlapLAddr)
        
    def test_findOverlapIter_not_the_first_RefOverlap(self):
        queryCursor           = NCListCursor(None, self._queryNcList, 3, 0)
        refCursor             = NCListCursor(None, self._refNcList,   4, 0)
        queryTranscript       = queryCursor.getTranscript()
        done                  = True
        (cursor, done, empty) = self._iFOO.findOverlapIter(queryTranscript, refCursor, done)
        obsFirstOverlapLAddr  = (cursor._lIndex, done, empty)
        expFirstOverlapLAddr  = 1, True, False
        self.assertEquals(expFirstOverlapLAddr, obsFirstOverlapLAddr)
        
    def test_moveDown(self):
        refCursor = NCListCursor(None, self._refNcList, 0, 0)
        refCursor.moveDown()
        expFirstChildLAddr = 2
        self.assertEquals(expFirstChildLAddr, refCursor._lIndex) 
    
    def test_moveUp(self):
        refCursor = NCListCursor(None, self._refNcList, 4, 0)
        refCursor.moveUp()
        expFirstChildLAddr = 0
        self.assertEquals(expFirstChildLAddr, refCursor._lIndex) 
    
    def test_moveRight(self):
        refCursor = NCListCursor(None, self._refNcList, 3, 0)
        refCursor.moveRight()
        expFirstChildLAddr = 4
        self.assertEquals(expFirstChildLAddr, refCursor._lIndex) 
       
    def test_moveNext(self):
        refCursor = NCListCursor(None, self._refNcList, 6, 0)
        refCursor.moveNext()
        expFirstChildLAddr = 1
        self.assertEquals(expFirstChildLAddr, refCursor._lIndex) 

    def test_not_findOverlapIter_between2RefIntervals(self):
        inputQueryGff3FileName = 'query2.gff3'
        self._writeQueryGff3File2(inputQueryGff3FileName)
        self._outputGff3FileName = 'overlaps.gff3'
        iMock = MockFindOverlapsWithServeralIntervals_case1()
        iMock.write(self._inputRefGff3FileName)
        _iFOO = FindOverlapsOptim(0)
        _iFOO.setRefFileName(self._inputRefGff3FileName, "gff3")
        _iFOO.setQueryFileName(inputQueryGff3FileName, "gff3")
        _iFOO.setOutputFileName(self._outputGff3FileName)
        _iFOO.prepareIntermediateFiles()
        _iFOO.createNCLists()
        _queryNcList          = _iFOO._ncLists[QUERY]["chr1"]
        _refNcList            = _iFOO._ncLists[REFERENCE]["chr1"]
        queryCursor           = NCListCursor(None, _queryNcList, 0, 0)
        refCursor             = NCListCursor(None, _refNcList,   0, 0)
        queryTranscript       = queryCursor.getTranscript()
        done                  = True
        (cursor, done, empty) = _iFOO.findOverlapIter(queryTranscript, refCursor, done)
        lIndex                = cursor._lIndex
        obsFirstOverlapLAddr  = (lIndex, done, empty)
        expFirstOverlapLAddr  = 1, False, True
        self.assertEquals(expFirstOverlapLAddr, obsFirstOverlapLAddr)
        os.remove(inputQueryGff3FileName) 

    def _writeQueryGff3File2(self, fileName):
        f = open(fileName, 'w')
        f.write("chr1\tquery\ttest1\t1100\t1150\t126\t+\t.\tID=test1.1;Name=test1.1\n")
        f.write("chr1\tquery\ttest2\t1250\t1300\t781\t+\t.\tID=test1.2;Name=test1.2\n")
        f.close()  
        
    def _writeQueryGff3File(self, fileName):
        f = open(fileName, 'w')
        f.write("chr1\tquery\ttest1.1\t25\t150\t126\t+\t.\tID=test1.1;Name=test1.1\n")
        f.write("chr1\tquery\ttest1.2\t70\t850\t781\t+\t.\tID=test1.2;Name=test1.2\n")
        f.write("chr1\tquery\ttest1.3\t550\t850\t201\t+\t.\tID=test1.3;Name=test1.3\n")
        f.write("chr1\tquery\ttest1.4\t925\t1025\t101\t+\t.\tID=test1.4;Name=test1.4\n")
        f.write("chr1\tquery\ttest1.5\t1201\t1210\t10\t+\t.\tID=test1.5;Name=test1.5\n")
        f.write("chr1\tquery\ttest1.6\t1500\t1600\t101\t+\t.\tID=test1.6;Name=test1.6\n")
        f.close()
        
if __name__ == "__main__":
    unittest.main()
