from commons.core.parsing.SsrParser import SsrParser
import unittest


class Test_SsrParser(unittest.TestCase):


    def test_setAttributesFromString(self):
        ssrLine = "MRRE1H001B07RM1\t1\t2\tta\t19\t153\t190\t734"
        
        iSsrParser = SsrParser()
        iSsrParser.setAttributesFromString(ssrLine)
        
        obsBES_name = iSsrParser.getBesName()
        obsBES_redundancy = iSsrParser.getBesRedundancy()
        obsSSR_nbNucleotides = iSsrParser.getSsrNbNucleotides()
        obsSSR_Motif = iSsrParser.getSsrMotif()
        obsSSR_Motif_number = iSsrParser.getSsrMotifNumber()
        obsSSR_start = iSsrParser.getSsrStart()
        obsSSR_end = iSsrParser.getSsrEnd()
        obsBES_size = iSsrParser.getBesSize()
        
        expBES_name = 'MRRE1H001B07RM1'
        expBES_redundancy = '1'
        expSSR_nbNucleotides = '2'
        expSSR_Motif = 'ta'
        expSSR_Motif_number = '19'
        expSSR_start = '153'
        expSSR_end = '190'
        expBES_size = '734'
        
        self.assertEquals(expBES_name, obsBES_name)
        self.assertEquals(expBES_redundancy, obsBES_redundancy)
        self.assertEquals(expSSR_nbNucleotides, obsSSR_nbNucleotides)
        self.assertEquals(expSSR_Motif, obsSSR_Motif)
        self.assertEquals(expSSR_Motif_number, obsSSR_Motif_number)
        self.assertEquals(expSSR_start, obsSSR_start)
        self.assertEquals(expSSR_end, obsSSR_end)
        self.assertEquals(expBES_size, obsBES_size)
        
    def test_setAttributesFromString_empty_BESName(self):
        ssrLine = "\t1\t2\tta\t19\t153\t190\t734"
        
        iSsrParser = SsrParser()
        iSsrParser.setAttributesFromString(ssrLine)
        
        obsBES_name = iSsrParser.getBesName()
        obsBES_redundancy = iSsrParser.getBesRedundancy()
        obsSSR_nbNucleotides = iSsrParser.getSsrNbNucleotides()
        obsSSR_Motif = iSsrParser.getSsrMotif()
        obsSSR_Motif_number = iSsrParser.getSsrMotifNumber()
        obsSSR_start = iSsrParser.getSsrStart()
        obsSSR_end = iSsrParser.getSsrEnd()
        obsBES_size = iSsrParser.getBesSize()
        
        expBES_name = ''
        expBES_redundancy = ''
        expSSR_nbNucleotides = ''
        expSSR_Motif = ''
        expSSR_Motif_number = ''
        expSSR_start = ''
        expSSR_end = ''
        expBES_size = ''
        
        self.assertEquals(expBES_name, obsBES_name)
        self.assertEquals(expBES_redundancy, obsBES_redundancy)
        self.assertEquals(expSSR_nbNucleotides, obsSSR_nbNucleotides)
        self.assertEquals(expSSR_Motif, obsSSR_Motif)
        self.assertEquals(expSSR_Motif_number, obsSSR_Motif_number)
        self.assertEquals(expSSR_start, obsSSR_start)
        self.assertEquals(expSSR_end, obsSSR_end)
        self.assertEquals(expBES_size, obsBES_size)

    def test_setAttributesFromString_less_than_8_fields(self):
        ssrLine = "1\t2\tta\t19\t153\t190\t734"
        
        iSsrParser = SsrParser()
        iSsrParser.setAttributesFromString(ssrLine)
        
        obsBES_name = iSsrParser.getBesName()
        obsBES_redundancy = iSsrParser.getBesRedundancy()
        obsSSR_nbNucleotides = iSsrParser.getSsrNbNucleotides()
        obsSSR_Motif = iSsrParser.getSsrMotif()
        obsSSR_Motif_number = iSsrParser.getSsrMotifNumber()
        obsSSR_start = iSsrParser.getSsrStart()
        obsSSR_end = iSsrParser.getSsrEnd()
        obsBES_size = iSsrParser.getBesSize()
        
        expBES_name = ''
        expBES_redundancy = ''
        expSSR_nbNucleotides = ''
        expSSR_Motif = ''
        expSSR_Motif_number = ''
        expSSR_start = ''
        expSSR_end = ''
        expBES_size = ''
        
        self.assertEquals(expBES_name, obsBES_name)
        self.assertEquals(expBES_redundancy, obsBES_redundancy)
        self.assertEquals(expSSR_nbNucleotides, obsSSR_nbNucleotides)
        self.assertEquals(expSSR_Motif, obsSSR_Motif)
        self.assertEquals(expSSR_Motif_number, obsSSR_Motif_number)
        self.assertEquals(expSSR_start, obsSSR_start)
        self.assertEquals(expSSR_end, obsSSR_end)
        self.assertEquals(expBES_size, obsBES_size)
        
    def test_setAttributes(self):
        lResults = ['MRRE1H001B07RM1','1','2','ta','19','153','190','734']
        lineNumber = 1
        
        iSsrParser = SsrParser()
        iSsrParser.setAttributes(lResults, lineNumber)
        
        obsBES_name = iSsrParser.getBesName()
        obsBES_redundancy = iSsrParser.getBesRedundancy()
        obsSSR_nbNucleotides = iSsrParser.getSsrNbNucleotides()
        obsSSR_Motif = iSsrParser.getSsrMotif()
        obsSSR_Motif_number = iSsrParser.getSsrMotifNumber()
        obsSSR_start = iSsrParser.getSsrStart()
        obsSSR_end = iSsrParser.getSsrEnd()
        obsBES_size = iSsrParser.getBesSize()
        
        expBES_name = 'MRRE1H001B07RM1'
        expBES_redundancy = '1'
        expSSR_nbNucleotides = '2'
        expSSR_Motif = 'ta'
        expSSR_Motif_number = '19'
        expSSR_start = '153'
        expSSR_end = '190'
        expBES_size = '734'
        
        self.assertEquals(expBES_name, obsBES_name)
        self.assertEquals(expBES_redundancy, obsBES_redundancy)
        self.assertEquals(expSSR_nbNucleotides, obsSSR_nbNucleotides)
        self.assertEquals(expSSR_Motif, obsSSR_Motif)
        self.assertEquals(expSSR_Motif_number, obsSSR_Motif_number)
        self.assertEquals(expSSR_start, obsSSR_start)
        self.assertEquals(expSSR_end, obsSSR_end)
        self.assertEquals(expBES_size, obsBES_size)
        
    def test_eq_Equals(self):
        SsrParser1 = SsrParser('MRRE1H001A12RM1', '1', '4', 'ttta', '6', '272', '295', '724')
        SsrParser2 = SsrParser('MRRE1H001A12RM1', '1', '4', 'ttta', '6', '272', '295', '724')
        
        self.assertTrue(SsrParser1 == SsrParser2)
        
    def test_eq_NotEquals(self):
        SsrParser1 = SsrParser('MRRE1H001A12RM1', '1', '4', 'ttta', '6', '272', '295', '724')
        SsrParser2 = SsrParser('MRRE1H001A12RM3', '1', '5', 'ttta', '6', '272', '295', '852')
        
        self.assertFalse(SsrParser1 == SsrParser2)

if __name__ == "__main__":
    unittest.main()