#! /usr/bin/env python
"""Transform a BED with our local GBrowse format to UCSC BED format"""

import os
from optparse import OptionParser
from bedParser import *
from bedWriter import *
from progress import *


if __name__ == "__main__":
  
  # parse command line
  parser = OptionParser()
  parser.add_option("-i", "--input",          dest="inputFileName",  action="store",               type="string", help="input file")
  parser.add_option("-o", "--output",         dest="outputFileName", action="store",               type="string", help="output file")
  parser.add_option("-v", "--verbosity",      dest="verbosity",      action="store", default=1,    type="int",    help="trace level")
  (options, args) = parser.parse_args()
  

  parser = BedParser(options.inputFileName, options.verbosity)
  writer = BedWriter(options.outputFileName, options.verbosity)
  writer.copyProperties(parser)

  progress = Progress(parser.getNbTranscripts(), "Scanning file %s" % (options.inputFileName), options.verbosity)
  for transcript in parser.getIterator():
    transcript.chromosome = transcript.chromosome.replace("arm_", "chr")
    if transcript.chromosome.find("Het") == -1:
      writer.addTranscript(transcript)
    progress.inc()
  progress.done()
      