#! /usr/bin/env python
"""Restrict a transcript list with some parameters (regions)"""

from optparse import OptionParser
from structure.transcriptContainer import *
from writer.transcriptWriter import *
from misc.progress import *


if __name__ == "__main__":
  
  # parse command line
  description = "Restrict Genomic Coordinates: Keep the coordinates which are located in a given position. [Category: Data Selection]"

  parser = OptionParser(description = description)
  parser.add_option("-i", "--input",      dest="inputFileName",  action="store",                     type="string", help="input file [compulsory] [format: file in transcript format given by -f]")
  parser.add_option("-f", "--format",     dest="format",         action="store",                     type="string", help="format [compulsory] [format: transcript file format]")
  parser.add_option("-c", "--chromosome", dest="chromosome",     action="store",      default=None,  type="string", help="chromosome [format: string]")
  parser.add_option("-s", "--start",      dest="start",          action="store",      default=None,  type="int",    help="start [format: int]")
  parser.add_option("-e", "--end",        dest="end",            action="store",      default=None,  type="int",    help="end [format: int]")
  parser.add_option("-o", "--output",     dest="outputFileName", action="store",                     type="string", help="output file [format: output file in GFF3 format]")
  parser.add_option("-v", "--verbosity",  dest="verbosity",      action="store",      default=1,     type="int",    help="trace level [format: int]")
  parser.add_option("-l", "--log",        dest="log",            action="store_true", default=False,                help="write a log file [format: bool] [default: false]")
  (options, args) = parser.parse_args()

  parser = TranscriptContainer(options.inputFileName, options.format, options.verbosity)
  writer = TranscriptWriter(options.outputFileName, options.format, options.verbosity)
    
  nbTranscripts = parser.getNbTranscripts()
  progress      = Progress(nbTranscripts, "Parsing file %s" % (options.inputFileName), options.verbosity)
  
  nbTotal = 0
  nbKept  = 0
  for transcript in parser.getIterator():
    progress.inc()
    nbTotal += 1
    if options.chromosome != None and options.chromosome != transcript.chromosome:
      continue
    if options.start != None and options.start > transcript.end:
      continue
    if options.end != None and options.end < transcript.start:
      continue
    nbKept += 1
    writer.addTranscript(transcript)
  progress.done()
  
  writer.write()
    
  print "%d out of %d are kept (%f%%)" % (nbKept, nbTotal, (float(nbKept) / nbTotal * 100))    
