#! /usr/bin/env python
"""Explode wig files into several files, one for each chromosome"""

import os
import re
from optparse import OptionParser


if __name__ == "__main__":
  
  # parse command line
  description = "Wig Exploder: Explode a big WIG file into several smaller WIG files (one per chromosome). [Category: Personnal]"

  parser = OptionParser(description = description)
  parser.add_option("-i", "--input",            dest="inputFileName", action="store",                     type="string", help="input file [compulsory] [format: file in WIG format]")
  parser.add_option("-o", "--output",           dest="output",        action="store",      default=None,  type="string", help="output directory [compulsory] [format: directory]")
  parser.add_option("-v", "--verbosity",        dest="verbosity",     action="store",      default=1,     type="int",    help="trace level [format: int]")
  (options, args) = parser.parse_args()

  inputFile = open(options.inputFileName)

  files = {}
  file  = None

  for line in inputFile:
    line = line.strip()

    m1 = re.search(r"^\s*fixedStep\s+chrom=(\S+)\s+start=\d+\s+step=\d+\s*$", line)
    m2 = re.search(r"^\s*fixedStep\s+chrom=(\S+)\s+start=\d+\s+step=\d+\s+span=\d+\s*$", line)
    m3 = re.search(r"^\s*variableStep\s+chrom=(\S+)\s*$", line)
    m4 = re.search(r"^\s*variableStep\s+chrom=(\S+)span=\d+\s*$", line)

    m = None
    if m1 != None:
      m = m1
    elif m2 != None:
      m = m2
    elif m3 != None:
      m = m3
    elif m4 != None:
      m = m4

    if m != None:
      chromosome = m.group(1)

      if chromosome in files:
        file = files[chromosome]
      else:
        file = open("%s%s%s.wig" % (options.output, os.sep, chromosome), "w")
        files[chromosome] = file

    if file == None:
      sys.exit("Header is missing! Aborting...")

    file.write("%s\n" % (line))

  inputFile.close()

  for chromosome in files:
    files[chromosome].close()
