import re
import sys
from parser.mapperParser import *


class ShrimpParser(MapperParser):
  """A class that parses the output of Shrimp"""

  def __init__(self, fileName, verbosity = 0):
    super(ShrimpParser, self).__init__(fileName, verbosity)


  def __del__(self):
    super(ShrimpParser, self).__del__()


  def skipFirstLines(self):
    self.handle.readline()


  def parseLine(self, line):
    m = re.search(r"^\s*>([^\t]+)\t+(\S+)\s+([+-])\s+(\d+)\s+(\d+)\s+(\d+)\s+(\d+)\s+(\d+)\s+(\d+)\s+(\S+)\s*$", line)
    if m == None:
      sys.exit("Line " + line + " does not look like a Shrimp line")

    mapping = Mapping()

    mapping.queryInterval.setName(m.group(1))
    mapping.queryInterval.setStart(min(int(m.group(6)), int(m.group(7))))
    mapping.queryInterval.setEnd(max(int(m.group(6)), int(m.group(7))))

    mapping.targetInterval.setChromosome(m.group(2))
    mapping.targetInterval.setStart(min(int(m.group(4)), int(m.group(5))))
    mapping.targetInterval.setEnd(max(int(m.group(4)), int(m.group(5))))

    mapping.setSize(int(m.group(8)))
    mapping.setDirection(m.group(3))

    editString   = m.group(10)
    nbMismatches = 0
    nbGaps       = 0
    while editString != "":
      m = re.search(r"^(\d+)(\D.*)$", editString)
      if m != None:
        editString = m.group(2)
      else:
        m = re.search(r"^(\d+)$", editString)
        if m != None:
          editString = ""
        else:
          m = re.search(r"^([A-Z])(.*)$", editString)
          if m != None:
            nbMismatches += 1
            editString    = m.group(2)
          else:
            m = re.search(r"^\((\w+)\)(.*)$", editString)
            if m != None:
              nbGaps    += len(m.group(1))
              editString = m.group(2)
            else:
              m = re.search(r"^-(.*)$", editString)
              if m != None:
                nbGaps    += 1
                editString = m.group(1)
              else:
                sys.exit("Cannot understand edit string %s from line %s" % (editString, line))

    mapping.setNbMismatches(nbMismatches)
    mapping.setNbGaps(nbGaps)

    return mapping
