from structure.transcript import *
from structure.transcriptList import *
from writer.transcriptListWriter import *


class BedWriter(TranscriptListWriter):
  """
  A class that writes a transcript list into a file with BED format
  @ivar fileName: name of the file 
  @type fileName: string
  @ivar handle:   handle to the file
  @type handle:   file handle
  @ivar header:   first lines of the file
  @type header:   string
  """


  def __init__(self, fileName, verbosity = 0):
    """
    Constructor
    @param fileName:  name of the file 
    @type  fileName:  string
    @param verbosity: verbosity
    @type  verbosity: int
    """
    self.header = "track name=reads description=\"Reads\" useScore=0 visibility=full offset=0\n"
    super(BedWriter, self).__init__(fileName, verbosity)
    
    
  def setTitle(self, title):
    """
    Set the title of the track
    @param title: the title of the track
    @type  title: string
    """
    if title != None:
      self.header = "track name=%s description=\"%s\" useScore=0 visibility=full offset=0\n" % (title, title)


  def copyProperties(self, bedParser):
    """
    Copy the properties collected by a parser, to produce a similar output
    @param bedParser: a BED Parser parser
    @type  bedParser: class L{BedParser<BedParser>}
    """
    self.setTitle(bedParser.title)
    

  def printTranscript(self, transcript):
    """
    Export the given transcript with GBrowse format
    @param transcript: transcript to be printed
    @type  transcript: class L{Transcript<Transcript>}
    @return:           a string
    """
    return transcript.printBed()

