import re
from parsing.mapperParser import *
from misc import utils


class AxtParser(MapperParser):
  """A class that parses AXT (as given by Mosaik)"""

  def __init__(self, fileName, verbosity = 0):
    super(AxtParser, self).__init__(fileName, verbosity)


  def __del__(self):
    super(AxtParser, self).__del__()


  def getFileFormats():
    return ["axt"]
  getFileFormats = staticmethod(getFileFormats)


  def skipFirstLines(self):
    pass


  def getInfos(self):
    self.chromosomes = set()
    self.nbMappings  = 0
    self.size        = 0
    cpt              = 0
    self.reset()
    for line in self.handle:
      line = line.strip()
      if line == "": continue
      if cpt % 3 == 0:
        line  = line.strip()
        parts = line.split(" ")
        self.chromosomes.add(parts[1])
        self.size       += int(parts[6])
        self.nbMappings += 1
      cpt += 1
      if self.verbosity >= 10 and self.nbMappings % 100000 == 0:
        sys.stdout.write("  %d mappings read\r" % (self.nbMappings))
        sys.stdout.flush()
    self.reset()
    if self.verbosity >= 10:
      print "  %d mappings read" % (self.nbMappings)
      print "Done."
    

  def parseLine(self, line):

    if line.strip() == "":
      for line in self.handle:
        self.currentLineNb += 1
        break
    if line.strip() == "":
      return None

    m = re.search(r"^\s*\d+\s+(\S+)\s+(\d+)\s+(\d+)\s+(\S+)\s+(\d+)\s+(\d+)\s+([+-])\s+\d+\s*$", line)
    if m == None:
      sys.exit("\nLine %d '%s' does not have an AXT format" % (self.currentLineNb, line))

    mapping = Mapping()
    
    subMapping = SubMapping()

    offset = -1 if mapping.direction == 1 else 0
    subMapping.queryInterval.setName(m.group(4))
    subMapping.queryInterval.setStart(min(int(m.group(5)), int(m.group(6)))-1)
    subMapping.queryInterval.setEnd(max(int(m.group(5)), int(m.group(6)))-1)
    subMapping.queryInterval.setDirection(m.group(7))

    subMapping.targetInterval.setChromosome(m.group(1))
    subMapping.targetInterval.setStart(min(int(m.group(2)), int(m.group(3))) + offset)
    subMapping.targetInterval.setEnd(max(int(m.group(2)), int(m.group(3))) + offset)
    subMapping.targetInterval.setDirection(1)

    subMapping.setSize(min(subMapping.targetInterval.size, subMapping.queryInterval.size))
    subMapping.setDirection(m.group(7))

    mapping.addSubMapping(subMapping)

    mapping.setDirection(m.group(7))
    mapping.targetInterval.setChromosome(m.group(1))
    mapping.targetInterval.setStart(min(int(m.group(2)), int(m.group(3))) + offset)
    mapping.targetInterval.setEnd(max(int(m.group(2)), int(m.group(3))) + offset)

    mapping.queryInterval.setName(m.group(4))
    mapping.queryInterval.setStart(min(int(m.group(5)), int(m.group(6)))-1)
    mapping.queryInterval.setEnd(max(int(m.group(5)), int(m.group(6)))-1)

    mapping.setSize(min(mapping.targetInterval.size, mapping.queryInterval.size))

    for line in self.handle:
      string1 = line.strip()
      self.currentLineNb += 1
      break
    for line in self.handle:
      string2 = line.strip()
      self.currentLineNb += 1
      break
    mapping.setNbMismatches(utils.getHammingDistance(string1, string2))
    mapping.setNbGaps(0)

    return mapping


