#! /usr/bin/env python
#
# Copyright INRA-URGI 2009-2010
# 
# This software is governed by the CeCILL license under French law and
# abiding by the rules of distribution of free software. You can use,
# modify and/ or redistribute the software under the terms of the CeCILL
# license as circulated by CEA, CNRS and INRIA at the following URL
# "http://www.cecill.info".
# 
# As a counterpart to the access to the source code and rights to copy,
# modify and redistribute granted by the license, users are provided only
# with a limited warranty and the software's author, the holder of the
# economic rights, and the successive licensors have only limited
# liability.
# 
# In this respect, the user's attention is drawn to the risks associated
# with loading, using, modifying and/or developing or reproducing the
# software by the user in light of its specific status of free software,
# that may mean that it is complicated to manipulate, and that also
# therefore means that it is reserved for developers and experienced
# professionals having in-depth computer knowledge. Users are therefore
# encouraged to load and test the software's suitability as regards their
# requirements in conditions enabling the security of their systems and/or
# data to be ensured and, more generally, to use and operate it in the
# same conditions as regards security.
# 
# The fact that you are presently reading this means that you have had
# knowledge of the CeCILL license and that you accept its terms.
#
"""
Read a mapping file (many formats supported) and select some of them
Mappings should be sorted by read names
"""

from optparse import OptionParser
from SMART.Java.Python.structure.TranscriptContainer import TranscriptContainer
from SMART.Java.Python.toolLauncher.RnaFoldLauncher import RnaFoldLauncher
from commons.core.writer.Gff3Writer import Gff3Writer


class Fold(object):
    """
    Fold a series of transcripts
    """

    def __init__(self, verbosity = 0):
        self.verbosity       = verbosity
        self.rnaFoldLauncher = RnaFoldLauncher(verbosity)
        self.gff3Writer      = None


    def setInputFileName(self, fileName, format):
        transcriptContainer = TranscriptContainer(fileName, format, options.verbosity)
        self.rnaFoldLauncher.setTranscriptList(transcriptContainer)

    
    def setOutputFileName(self, fileName):
        self.gff3Writer = Gff3Writer("%s.gff3" % (fileName), self.verbosity)


    def setGenomeFileName(self, fileName):
        self.rnaFoldLauncher.setGenomeFile(fileName)


    def setExtensions(self, fivePrime, threePrime):
        self.rnaFoldLauncher.setExtensions(fivePrime, threePrime)


    def start(self):
        self.gff3Writer.addTranscriptList(self.rnaFoldLauncher.getResults())



if __name__ == "__main__":
    
    # parse command line
    description = "Fold v1.0.1: Fold a list of transcript and give the energy. [Category: Personal]"

    parser = OptionParser(description = description)
    parser.add_option("-i", "--input",      dest="inputFileName",  action="store",            type="string", help="input file [compulsory] [format: file in transcript format given by -f]")
    parser.add_option("-f", "--format",     dest="format",         action="store",            type="string", help="format of file [compulsory] [format: transcript file format]")
    parser.add_option("-o", "--output",     dest="outputFileName", action="store",            type="string", help="output file [format: output file in GFF3 format]")
    parser.add_option("-g", "--genome",     dest="genomeFileName", action="store",            type="string", help="genome file name [format: file in FASTA format]")
    parser.add_option("-5", "--fivePrime",  dest="fivePrime",      action="store",            type="int",    help="extend towards the 5' end [format: int]")
    parser.add_option("-3", "--threePrime", dest="threePrime",     action="store",            type="int",    help="extend towards the 3' end [format: int]")
    parser.add_option("-v", "--verbosity",  dest="verbosity",      action="store", default=1, type="int",    help="trace level [format: int]")
    (options, args) = parser.parse_args()

    folder = Fold(options.verbosity)
    folder.setInputFileName(options.inputFileName, options.format)
    folder.setOutputFileName(options.outputFileName)
    folder.setExtensions(options.fivePrime, options.threePrime)
    folder.setGenomeFileName(options.genomeFileName)
    folder.start()
