/*
 * Decompiled with CFR 0.152.
 */
import java.awt.GridLayout;
import java.util.LinkedList;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class ProgramOption {
    boolean input = true;
    String identifier = null;
    String type = null;
    String comment = null;
    boolean compulsory = false;
    String[] format = null;
    String formatIdentifier = null;
    ProgramOption associatedOption = null;
    String defaultValue = "";
    String[] choices = null;
    JComponent component = null;
    JPanel panel = null;

    public void setInput(boolean bl) {
        this.input = bl;
    }

    public void setIdentifier(String string) {
        this.identifier = string;
    }

    public void setType(String string) {
        this.type = string;
    }

    public void setComment(String string) {
        this.comment = string;
    }

    public void setCompulsory(boolean bl) {
        this.compulsory = bl;
    }

    public void setFormat(String[] stringArray) {
        this.format = stringArray;
    }

    public void setFormat(String string) {
        this.format = new String[1];
        this.format[0] = string;
    }

    public void setFormatIdentifier(String string) {
        this.formatIdentifier = string;
    }

    public void setAssociatedOption(ProgramOption programOption) {
        this.associatedOption = programOption;
    }

    public void setChoices(String[] stringArray) {
        this.choices = new String[stringArray.length + 1];
        this.choices[0] = "---";
        for (int i = 0; i < stringArray.length; ++i) {
            this.choices[i + 1] = stringArray[i];
        }
    }

    public void setDefault(String string) {
        this.defaultValue = string;
    }

    public boolean isInput() {
        return this.input;
    }

    public boolean checkSettings() {
        if (this.identifier == null) {
            return false;
        }
        if (this.type == null) {
            return false;
        }
        if (this.comment == null) {
            return false;
        }
        if (this.comment == null) {
            return false;
        }
        return "choice".compareToIgnoreCase(this.type) != 0 || this.choices != null;
    }

    public JPanel getPanel() {
        if (this.panel != null) {
            return this.panel;
        }
        String string = this.comment;
        if (this.compulsory) {
            string = string + " [*]";
        }
        GridLayout gridLayout = new GridLayout(1, 0);
        this.panel = new JPanel(false);
        this.panel.setLayout(gridLayout);
        JLabel jLabel = new JLabel(string);
        if (this.type == null) {
            System.out.println("Error! Option '" + this.identifier + "' is not set!");
        }
        if ("int".compareToIgnoreCase(this.type) == 0 || "float".compareToIgnoreCase(this.type) == 0 || "string".compareToIgnoreCase(this.type) == 0 || "file".compareToIgnoreCase(this.type) == 0 && !this.input) {
            this.component = new JTextField();
            if (this.defaultValue != null) {
                ((JTextField)this.component).setText(this.defaultValue);
            }
            jLabel.setLabelFor(this.component);
            this.panel.add(jLabel);
            this.panel.add(this.component);
        } else if ("file".compareToIgnoreCase(this.type) == 0) {
            this.component = new JComboBox<String>(Global.fileNames);
            jLabel.setLabelFor(this.component);
            this.panel.add(jLabel);
            this.panel.add(this.component);
        } else if ("boolean".compareToIgnoreCase(this.type) == 0) {
            this.component = new JCheckBox();
            if (this.defaultValue != null && this.defaultValue.compareToIgnoreCase("true") == 0) {
                ((JCheckBox)this.component).setSelected(true);
            }
            jLabel.setLabelFor(this.component);
            this.panel.add(jLabel);
            this.panel.add(this.component);
        } else if ("format".compareToIgnoreCase(this.type) == 0) {
            Vector<String> vector = new Vector<String>();
            for (String string2 : this.format) {
                if (Global.formats.getFormats(string2) == null) {
                    System.out.println("Do not know how to handle format '" + string2 + "'.");
                }
                vector.addAll(Global.formats.getFormats(string2).getFormats());
            }
            this.component = new JComboBox(vector);
            jLabel.setLabelFor(this.component);
            this.panel.add(jLabel);
            this.panel.add(this.component);
        } else if ("files".compareToIgnoreCase(this.type) == 0) {
            JButton jButton = new JButton("file...");
            this.component = new JTextField();
            jLabel.setLabelFor(this.component);
            this.panel.add(jLabel);
            this.panel.add(this.component);
            this.panel.add(jButton);
            Global.otherFileConcatenationChooser.put(jButton, (JTextField)this.component);
        } else if ("directory".compareToIgnoreCase(this.type) == 0) {
            JButton jButton = new JButton("directory...");
            this.component = new JTextField();
            jLabel.setLabelFor(this.component);
            this.panel.add(jLabel);
            JPanel jPanel = new JPanel(false);
            jPanel.setLayout(new BoxLayout(jPanel, 2));
            jPanel.add(this.component);
            jPanel.add(jButton);
            this.panel.add(jPanel);
            Global.otherDirectoriesChooser.put(jButton, (JTextField)this.component);
        } else if ("choice".compareToIgnoreCase(this.type) == 0) {
            this.component = new JComboBox<String>(this.choices);
            jLabel.setLabelFor(this.component);
            this.panel.add(jLabel);
            this.panel.add(this.component);
        } else {
            System.out.println("Do not know how to read type " + this.type);
        }
        return this.panel;
    }

    public JComponent getComponent() {
        if (this.component == null) {
            this.getPanel();
        }
        return this.component;
    }

    private String getValue() {
        if ("int".equals(this.type) || "float".equals(this.type) || "string".equals(this.type) || "file".equals(this.type) && !this.input || "directory".equals(this.type) || "files".equals(this.type)) {
            String string = ((JTextField)this.component).getText();
            if ("None".equals(string)) {
                return "";
            }
            return string;
        }
        if ("file".equals(this.type)) {
            return (String)((JComboBox)this.component).getSelectedItem();
        }
        if ("boolean".equals(this.type)) {
            return ((JCheckBox)this.component).isSelected() ? "true" : "false";
        }
        if ("format".equals(this.type)) {
            return (String)((JComboBox)this.component).getSelectedItem();
        }
        if ("choice".equals(this.type)) {
            String string = (String)((JComboBox)this.component).getSelectedItem();
            if ("---".equals(string)) {
                return "";
            }
            return string;
        }
        System.out.println("Do not know how to get value of '" + this.type + "' (" + this.identifier + ").");
        return null;
    }

    public String checkValue() {
        String string = this.getValue();
        if (this.compulsory && (string == null || "".equals(string))) {
            return "Option '" + this.comment + "' has no value... Please specify it.\n";
        }
        if ("int".equals(this.type)) {
            if (string != null && !"".equals(string) && !"None".equals(string)) {
                try {
                    int n = Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException) {
                    return "Option '" + this.comment + "' should be an integer... Please correct it.\n";
                }
            }
        } else if ("float".equals(this.type) && string != null && !"".equals(string)) {
            try {
                float f = Float.parseFloat(string);
            }
            catch (NumberFormatException numberFormatException) {
                return "Option '" + this.comment + "' should be a float... Please correct it.\n";
            }
        }
        return null;
    }

    public LinkedList<String> getCommand() {
        LinkedList<String> linkedList = new LinkedList<String>();
        if ("int".equals(this.type) || "float".equals(this.type) || "string".equals(this.type) || "file".equals(this.type) && !this.input || "format".equals(this.type) || "directory".equals(this.type) || "files".equals(this.type) || "choice".equals(this.type)) {
            String string = this.getValue();
            if (string.length() == 0) {
                return linkedList;
            }
            linkedList.add(this.identifier);
            linkedList.add(string);
            return linkedList;
        }
        if ("file".equals(this.type)) {
            String string = (String)((JComboBox)this.component).getSelectedItem();
            if (string == null) {
                return linkedList;
            }
            linkedList.add(this.identifier);
            linkedList.add(this.getValue());
            return linkedList;
        }
        if ("boolean".equals(this.type) || "bool".equals(this.type)) {
            if ("true".equals(this.getValue())) {
                linkedList.add(this.identifier);
            }
            return linkedList;
        }
        System.out.println("Cannot get type of option " + this.type + " (" + this.identifier + "): " + this.getValue());
        return null;
    }

    public File getOutputFile() {
        if (this.input) {
            return null;
        }
        String string = "";
        if (this.format != null) {
            string = this.format[0];
        }
        if (this.associatedOption != null) {
            string = this.associatedOption.getValue();
        }
        return new File(this.getValue(), Global.formats.getFormatType(string), string);
    }
}

