#! /usr/bin/env python
"""Modify the genomic coordinates of a file"""

import os
from optparse import OptionParser
from writer.transcriptWriter import *
from structure.transcriptContainer import *
from misc.progress import *
from misc.rPlotter import *


if __name__ == "__main__":
  
  # parse command line
  description = "Modify Genomic Coordinates: Extend or shrink a list of genomic coordinates. [Category: Data Modification]"

  parser = OptionParser(description = description)
  parser.add_option("-i", "--input",      dest="inputFileName",  action="store",                     type="string", help="input file [compulsory] [format: file in transcript format given by -f]")
  parser.add_option("-f", "--format",     dest="format",         action="store",                     type="string", help="format of the input [compulsory] [format: transcript file format]")
  parser.add_option("-o", "--output",     dest="outputFileName", action="store",                     type="string", help="output file [compulsory] [format: output file in GFF3 format]")
  parser.add_option("-s", "--start",      dest="start",          action="store",      default=None,  type="int",    help="restrict to the start of the transcript [format: int]")
  parser.add_option("-e", "--end",        dest="end",            action="store",      default=None,  type="int",    help="restrict to the end of the transcript [format: int]")
  parser.add_option("-5", "--fivePrime",  dest="fivePrime",      action="store",      default=None,  type="int",    help="extend to the 5' direction [format: int]")
  parser.add_option("-3", "--threePrime", dest="threePrime",     action="store",      default=None,  type="int",    help="extend to the 3' direction [format: int]")
  parser.add_option("-y", "--mysql",      dest="mysql",          action="store_true", default=False,                help="mySQL output [format: bool] [default: false]")
  parser.add_option("-v", "--verbosity",  dest="verbosity",      action="store",      default=1,     type="int",    help="trace level [format: int]")

  (options, args) = parser.parse_args()

  parser = TranscriptContainer(options.inputFileName, options.format, options.verbosity)
    
  writer = TranscriptWriter(options.outputFileName, "gff3", options.verbosity)
  if options.mysql:
    mySqlWriter = TranscriptWriter(options.outputFileName, "sql", options.verbosity)

  nbItems = 0
  nbItems = parser.getNbItems()
  print "%i items found" % (nbItems)

  progress = Progress(nbItems, "Analyzing sequences of " + options.inputFileName, options.verbosity)
  for transcript in parser.getIterator():
    if options.start != None:
      transcript.restrictStart(options.start)
    if options.end != None:
      transcript.restrictEnd(options.end)
    if options.fivePrime != None:
      transcript.extendStart(options.fivePrime)
    if options.threePrime != None:
      transcript.extendStart(options.threePrime)
      sqlWriter = TranscriptWriter(options.outputFileName, "sql", options.verbosity)

    writer.addTranscript(transcript)
    if options.mysql:
      mySqlWriter.addTranscript(transcript)

    progress.inc()
  progress.done()
  

  writer.write()
  if options.mysql:
    mySqlWriter.write()
