#ifndef GENOMIC_INTERVAL_HPP
#define GENOMIC_INTERVAL_HPP

#include "interval.hpp"
#include <stdio.h>
#include <stdlib.h>
#include <string>
#include <sstream>

class GenomicInterval: public Interval {

    public:
        string chromosome;

        GenomicInterval(string chromosome = "", unsigned int start = 0, unsigned int end = 0): Interval(start, end), chromosome(chromosome) { }

        bool onSameChromosome(const GenomicInterval &i) const {
            return (chromosome == i.chromosome);
        }

//      friend bool operator==(const GenomicInterval &i1, const GenomicInterval &i2) {
//          return ((i1.onSameChromosome(i2)) && (Interval::i1 == Interval::i2));
//      }

//      friend bool operator<(const GenomicInterval &i1, const GenomicInterval &i2) {
//          return ((i1.onSameChromosome(i2)) && (Interval::i1 < Interval::i2));
//      }

        friend ofstream& operator<<(ofstream &stream, const GenomicInterval &i) {
            stream << i.chromosome << '\t' << i.start << '\t' << i.end << '\n';
            return stream;
        }
        
        void parseFromLine(string &line) {
            string strStart, strEnd;
            istringstream iss(line);
            getline(iss, chromosome, '\t');
            getline(iss, strStart,   '\t');
            getline(iss, strEnd,     '\t');
            start = atoi(strStart.c_str());
            end   = atoi(strEnd.c_str());
            //cout << "read " << chromosome << ":" << start << ".." << end << endl;
        }

};

#endif
