from commons.core.parsing.BlatParser import BlatParser
import unittest


class Test_BlatParser(unittest.TestCase):


    def test_setAttributesFromString(self):
        blatLine = "315\t20\t0\t0\t3\t10\t2\t9\t+\tMRRE1H001H13FM1\t378\t0\t345\tchr16\t22053297\t21686950\t21687294\t4\t76,185,7,67,\t0,77,263,278,\t21686950,21687026,21687213,21687227,"
        
        iBlatParser = BlatParser()
        iBlatParser.setAttributesFromString(blatLine)
        
        obsmatch = iBlatParser.getMatch()
        obsmismatch = iBlatParser.getMismatch()
        obsrepMatch = iBlatParser.getRepMatch()
        obsN = iBlatParser.getN()
        obsQGapCount = iBlatParser.getQGapCount()
        obsQGapBases = iBlatParser.getQGapBases()
        obsTGapCount = iBlatParser.getTGapCount()
        obsTGapBases = iBlatParser.getTGapBases()
        obsstrand = iBlatParser.getStrand()
        obsQName = iBlatParser.getQName()
        obsQSize = iBlatParser.getQSize()
        obsQStart = iBlatParser.getQStart()
        obsQEnd = iBlatParser.getQEnd()
        obsTName = iBlatParser.getTName()
        obsTSize = iBlatParser.getTSize()
        obsTStart = iBlatParser.getTStart()
        obsTEnd = iBlatParser.getTEnd()
        obsblockCount = iBlatParser.getBlockCount()
        obsblockSizes = iBlatParser.getBlockSizes()
        obsqStarts = iBlatParser.getQStarts()
        obstStarts = iBlatParser.getTStarts()
        
        expmatch = "315"
        expmismatch = "20"
        exprepMatch = "0"
        expN = "0"
        expQGapCount = "3"
        expQGapBases = "10"
        expTGapCount = "2"
        expTGapBases = "9"
        expstrand = "+"
        expQName = "MRRE1H001H13FM1"
        expQSize = "378"
        expQStart = "0"
        expQEnd = "345"
        expTName = "chr16"
        expTSize = "22053297"
        expTStart = "21686950"
        expTEnd = "21687294"
        expblockCount = "4"
        expblockSizes = "76,185,7,67,"
        expqStarts = "0,77,263,278,"
        exptStarts = "21686950,21687026,21687213,21687227,"
        
        self.assertEquals(expmatch, obsmatch)
        self.assertEquals(expmismatch, obsmismatch)
        self.assertEquals(exprepMatch, obsrepMatch)
        self.assertEquals(expN, obsN)
        self.assertEquals(expQGapCount, obsQGapCount)
        self.assertEquals(expQGapBases, obsQGapBases)
        self.assertEquals(expTGapCount, obsTGapCount)
        self.assertEquals(expTGapBases, obsTGapBases)
        self.assertEquals(expstrand, obsstrand)
        self.assertEquals(expQName, obsQName)
        self.assertEquals(expQSize, obsQSize)
        self.assertEquals(expQStart, obsQStart)
        self.assertEquals(expQEnd, obsQEnd)
        self.assertEquals(expTName, obsTName)
        self.assertEquals(expTSize, obsTSize)
        self.assertEquals(expTStart, obsTStart)
        self.assertEquals(expTEnd, obsTEnd)
        self.assertEquals(expblockCount, obsblockCount)
        self.assertEquals(expblockSizes, obsblockSizes)
        self.assertEquals(expqStarts, obsqStarts)
        self.assertEquals(exptStarts, obstStarts)
        
    def test_setAttributesFromString_empty_QName(self):
        blatLine = "315\t20\t0\t0\t3\t10\t2\t9\t+\t\t378\t0\t345\tchr16\t22053297\t21686950\t21687294\t4\t76,185,7,67,\t0,77,263,278,\t21686950,21687026,21687213,21687227,"
        
        iBlatParser = BlatParser()
        iBlatParser.setAttributesFromString(blatLine)
        
        obsmatch = iBlatParser.getMatch()
        obsmismatch = iBlatParser.getMismatch()
        obsrepMatch = iBlatParser.getRepMatch()
        obsN = iBlatParser.getN()
        obsQGapCount = iBlatParser.getQGapCount()
        obsQGapBases = iBlatParser.getQGapBases()
        obsTGapCount = iBlatParser.getTGapCount()
        obsTGapBases = iBlatParser.getTGapBases()
        obsstrand = iBlatParser.getStrand()
        obsQName = iBlatParser.getQName()
        obsQSize = iBlatParser.getQSize()
        obsQStart = iBlatParser.getQStart()
        obsQEnd = iBlatParser.getQEnd()
        obsTName = iBlatParser.getTName()
        obsTSize = iBlatParser.getTSize()
        obsTStart = iBlatParser.getTStart()
        obsTEnd = iBlatParser.getTEnd()
        obsblockCount = iBlatParser.getBlockCount()
        obsblockSizes = iBlatParser.getBlockSizes()
        obsqStarts = iBlatParser.getQStarts()
        obstStarts = iBlatParser.getTStarts()
        
        expmatch = ""
        expmismatch = ""
        exprepMatch = ""
        expN = ""
        expQGapCount = ""
        expQGapBases = ""
        expTGapCount = ""
        expTGapBases = ""
        expstrand = ""
        expQName = ""
        expQSize = ""
        expQStart = ""
        expQEnd = ""
        expTName = ""
        expTSize = ""
        expTStart = ""
        expTEnd = ""
        expblockCount = ""
        expblockSizes = ""
        expqStarts = ""
        exptStarts = ""
        
        self.assertEquals(expmatch, obsmatch)
        self.assertEquals(expmismatch, obsmismatch)
        self.assertEquals(exprepMatch, obsrepMatch)
        self.assertEquals(expN, obsN)
        self.assertEquals(expQGapCount, obsQGapCount)
        self.assertEquals(expQGapBases, obsQGapBases)
        self.assertEquals(expTGapCount, obsTGapCount)
        self.assertEquals(expTGapBases, obsTGapBases)
        self.assertEquals(expstrand, obsstrand)
        self.assertEquals(expQName, obsQName)
        self.assertEquals(expQSize, obsQSize)
        self.assertEquals(expQStart, obsQStart)
        self.assertEquals(expQEnd, obsQEnd)
        self.assertEquals(expTName, obsTName)
        self.assertEquals(expTSize, obsTSize)
        self.assertEquals(expTStart, obsTStart)
        self.assertEquals(expTEnd, obsTEnd)
        self.assertEquals(expblockCount, obsblockCount)
        self.assertEquals(expblockSizes, obsblockSizes)
        self.assertEquals(expqStarts, obsqStarts)
        self.assertEquals(exptStarts, obstStarts)

    def test_setAttributesFromString_less_than_21_fields(self):
        blatLine = "315\t20\t0\t0\t3\t10\t2\t9\t378\t0\t345\tchr16\t22053297\t21686950\t21687294\t4\t76,185,7,67,\t0,77,263,278,\t21686950,21687026,21687213,21687227,"
        
        iBlatParser = BlatParser()
        iBlatParser.setAttributesFromString(blatLine)
        
        obsmatch = iBlatParser.getMatch()
        obsmismatch = iBlatParser.getMismatch()
        obsrepMatch = iBlatParser.getRepMatch()
        obsN = iBlatParser.getN()
        obsQGapCount = iBlatParser.getQGapCount()
        obsQGapBases = iBlatParser.getQGapBases()
        obsTGapCount = iBlatParser.getTGapCount()
        obsTGapBases = iBlatParser.getTGapBases()
        obsstrand = iBlatParser.getStrand()
        obsQName = iBlatParser.getQName()
        obsQSize = iBlatParser.getQSize()
        obsQStart = iBlatParser.getQStart()
        obsQEnd = iBlatParser.getQEnd()
        obsTName = iBlatParser.getTName()
        obsTSize = iBlatParser.getTSize()
        obsTStart = iBlatParser.getTStart()
        obsTEnd = iBlatParser.getTEnd()
        obsblockCount = iBlatParser.getBlockCount()
        obsblockSizes = iBlatParser.getBlockSizes()
        obsqStarts = iBlatParser.getQStarts()
        obstStarts = iBlatParser.getTStarts()
        
        expmatch = ""
        expmismatch = ""
        exprepMatch = ""
        expN = ""
        expQGapCount = ""
        expQGapBases = ""
        expTGapCount = ""
        expTGapBases = ""
        expstrand = ""
        expQName = ""
        expQSize = ""
        expQStart = ""
        expQEnd = ""
        expTName = ""
        expTSize = ""
        expTStart = ""
        expTEnd = ""
        expblockCount = ""
        expblockSizes = ""
        expqStarts = ""
        exptStarts = ""
        
        self.assertEquals(expmatch, obsmatch)
        self.assertEquals(expmismatch, obsmismatch)
        self.assertEquals(exprepMatch, obsrepMatch)
        self.assertEquals(expN, obsN)
        self.assertEquals(expQGapCount, obsQGapCount)
        self.assertEquals(expQGapBases, obsQGapBases)
        self.assertEquals(expTGapCount, obsTGapCount)
        self.assertEquals(expTGapBases, obsTGapBases)
        self.assertEquals(expstrand, obsstrand)
        self.assertEquals(expQName, obsQName)
        self.assertEquals(expQSize, obsQSize)
        self.assertEquals(expQStart, obsQStart)
        self.assertEquals(expQEnd, obsQEnd)
        self.assertEquals(expTName, obsTName)
        self.assertEquals(expTSize, obsTSize)
        self.assertEquals(expTStart, obsTStart)
        self.assertEquals(expTEnd, obsTEnd)
        self.assertEquals(expblockCount, obsblockCount)
        self.assertEquals(expblockSizes, obsblockSizes)
        self.assertEquals(expqStarts, obsqStarts)
        self.assertEquals(exptStarts, obstStarts)
        
    def test_setAttributes(self):
        lResults = ['315','20','0','0','3','10','2','9','+','MRRE1H001H13FM1','378','0','345','chr16','22053297','21686950','21687294','4','76,185,7,67,','0,77,263,278,','21686950,21687026,21687213,21687227,']
        lineNumber = 1
        
        iBlatParser = BlatParser()
        iBlatParser.setAttributes(lResults, lineNumber)
        
        obsmatch = iBlatParser.getMatch()
        obsmismatch = iBlatParser.getMismatch()
        obsrepMatch = iBlatParser.getRepMatch()
        obsN = iBlatParser.getN()
        obsQGapCount = iBlatParser.getQGapCount()
        obsQGapBases = iBlatParser.getQGapBases()
        obsTGapCount = iBlatParser.getTGapCount()
        obsTGapBases = iBlatParser.getTGapBases()
        obsstrand = iBlatParser.getStrand()
        obsQName = iBlatParser.getQName()
        obsQSize = iBlatParser.getQSize()
        obsQStart = iBlatParser.getQStart()
        obsQEnd = iBlatParser.getQEnd()
        obsTName = iBlatParser.getTName()
        obsTSize = iBlatParser.getTSize()
        obsTStart = iBlatParser.getTStart()
        obsTEnd = iBlatParser.getTEnd()
        obsblockCount = iBlatParser.getBlockCount()
        obsblockSizes = iBlatParser.getBlockSizes()
        obsqStarts = iBlatParser.getQStarts()
        obstStarts = iBlatParser.getTStarts()
        
        expmatch = "315"
        expmismatch = "20"
        exprepMatch = "0"
        expN = "0"
        expQGapCount = "3"
        expQGapBases = "10"
        expTGapCount = "2"
        expTGapBases = "9"
        expstrand = "+"
        expQName = "MRRE1H001H13FM1"
        expQSize = "378"
        expQStart = "0"
        expQEnd = "345"
        expTName = "chr16"
        expTSize = "22053297"
        expTStart = "21686950"
        expTEnd = "21687294"
        expblockCount = "4"
        expblockSizes = "76,185,7,67,"
        expqStarts = "0,77,263,278,"
        exptStarts = "21686950,21687026,21687213,21687227,"
        
        self.assertEquals(expmatch, obsmatch)
        self.assertEquals(expmismatch, obsmismatch)
        self.assertEquals(exprepMatch, obsrepMatch)
        self.assertEquals(expN, obsN)
        self.assertEquals(expQGapCount, obsQGapCount)
        self.assertEquals(expQGapBases, obsQGapBases)
        self.assertEquals(expTGapCount, obsTGapCount)
        self.assertEquals(expTGapBases, obsTGapBases)
        self.assertEquals(expstrand, obsstrand)
        self.assertEquals(expQName, obsQName)
        self.assertEquals(expQSize, obsQSize)
        self.assertEquals(expQStart, obsQStart)
        self.assertEquals(expQEnd, obsQEnd)
        self.assertEquals(expTName, obsTName)
        self.assertEquals(expTSize, obsTSize)
        self.assertEquals(expTStart, obsTStart)
        self.assertEquals(expTEnd, obsTEnd)
        self.assertEquals(expblockCount, obsblockCount)
        self.assertEquals(expblockSizes, obsblockSizes)
        self.assertEquals(expqStarts, obsqStarts)
        self.assertEquals(exptStarts, obstStarts)
        
    def test_eq_Equals_case1(self):
        BlatParser1 = BlatParser()
        BlatParser1.setMatch("315")
        BlatParser1.setMismatch("20")
        BlatParser1.setRepMatch("0")
        BlatParser1.setN("0")
        BlatParser1.setQGapCount("3")
        BlatParser1.setQGapBases("10")
        BlatParser1.setTGapCount("2")
        BlatParser1.setTGapBases("9")
        BlatParser1.setStrand("+")
        BlatParser1.setQName("MRRE1H001H13FM1")
        BlatParser1.setQSize("378")
        BlatParser1.setQStart("0")
        BlatParser1.setQEnd("345")
        BlatParser1.setTName("chr16")
        BlatParser1.setTSize("22053297")
        BlatParser1.setTStart("21686950")
        BlatParser1.setTEnd("21687294")
        BlatParser1.setBlockCount("4")
        BlatParser1.setBlockSizes("76,185,7,67,")
        BlatParser1.setQStarts("0,77,263,278,")
        BlatParser1.setTStarts("21686950,21687026,21687213,21687227,")
        
        BlatParser2 = BlatParser()
        BlatParser2.setMatch("315")
        BlatParser2.setMismatch("20")
        BlatParser2.setRepMatch("0")
        BlatParser2.setN("0")
        BlatParser2.setQGapCount("3")
        BlatParser2.setQGapBases("10")
        BlatParser2.setTGapCount("2")
        BlatParser2.setTGapBases("9")
        BlatParser2.setStrand("+")
        BlatParser2.setQName("MRRE1H001H13FM1")
        BlatParser2.setQSize("378")
        BlatParser2.setQStart("0")
        BlatParser2.setQEnd("345")
        BlatParser2.setTName("chr16")
        BlatParser2.setTSize("22053297")
        BlatParser2.setTStart("21686950")
        BlatParser2.setTEnd("21687294")
        BlatParser2.setBlockCount("4")
        BlatParser2.setBlockSizes("76,185,7,67,")
        BlatParser2.setQStarts("0,77,263,278,")
        BlatParser2.setTStarts("21686950,21687026,21687213,21687227,")
        
        self.assertTrue(BlatParser1 == BlatParser2) 
        
    def test_eq_Equals_case2(self):
        BlatParser1 = BlatParser()
        BlatParser1.setMatch("315")
        BlatParser1.setMismatch("20")
        BlatParser1.setRepMatch("0")
        BlatParser1.setN("0")
        BlatParser1.setQGapCount("3")
        BlatParser1.setQGapBases("10")
        BlatParser1.setTGapCount("2")
        BlatParser1.setTGapBases("9")
        BlatParser1.setStrand("+")
        BlatParser1.setQName("MRRE1H001H13FM1")
        BlatParser1.setQSize("378")
        BlatParser1.setQStart("0")
        BlatParser1.setQEnd("345")
        BlatParser1.setTName("chr16")
        BlatParser1.setTSize("22053297")
        BlatParser1.setTStart("21686950")
        BlatParser1.setTEnd("21687294")
        BlatParser1.setBlockCount("4")
        BlatParser1.setBlockSizes("76,185,7,67,")
        BlatParser1.setQStarts("0,77,263,278,")
        BlatParser1.setTStarts("21686950,21687026,21687213,21687227,")
        
        BlatParser2 = BlatParser()
        BlatParser2.setMatch("315")
        BlatParser2.setMismatch("20")
        BlatParser2.setRepMatch("0")
        BlatParser2.setN("0")
        BlatParser2.setQGapCount("3")
        BlatParser2.setQGapBases("10")
        BlatParser2.setTGapCount("2")
        BlatParser2.setTGapBases("9")
        BlatParser2.setStrand("+")
        BlatParser2.setQName("TotoFM2")
        BlatParser2.setQSize("378")
        BlatParser2.setQStart("0")
        BlatParser2.setQEnd("345")
        BlatParser2.setTName("chr16")
        BlatParser2.setTSize("22053297")
        BlatParser2.setTStart("21686950")
        BlatParser2.setTEnd("21687294")
        BlatParser2.setBlockCount("4")
        BlatParser2.setBlockSizes("76,185,7,67,")
        BlatParser2.setQStarts("0,77,263,278,")
        BlatParser2.setTStarts("21686950,21687026,21687213,21687227,")
        
        self.assertTrue(BlatParser1 == BlatParser2) 
        
    def test_eq_notEquals(self):
        BlatParser1 = BlatParser()
        BlatParser1.setMatch("315")
        BlatParser1.setMismatch("20")
        BlatParser1.setRepMatch("0")
        BlatParser1.setN("0")
        BlatParser1.setQGapCount("3")
        BlatParser1.setQGapBases("10")
        BlatParser1.setTGapCount("2")
        BlatParser1.setTGapBases("9")
        BlatParser1.setStrand("+")
        BlatParser1.setQName("MRRE1H001H13FM1")
        BlatParser1.setQSize("378")
        BlatParser1.setQStart("0")
        BlatParser1.setQEnd("345")
        BlatParser1.setTName("chr16")
        BlatParser1.setTSize("22053297")
        BlatParser1.setTStart("21686950")
        BlatParser1.setTEnd("21687294")
        BlatParser1.setBlockCount("4")
        BlatParser1.setBlockSizes("76,185,7,67,")
        BlatParser1.setQStarts("0,77,263,278,")
        BlatParser1.setTStarts("21686950,21687026,21687213,21687227,")
        
        BlatParser2 = BlatParser()
        BlatParser2.setMatch("315")
        BlatParser2.setMismatch("20")
        BlatParser2.setRepMatch("0")
        BlatParser2.setN("0")
        BlatParser2.setQGapCount("3")
        BlatParser2.setQGapBases("10")
        BlatParser2.setTGapCount("2")
        BlatParser2.setTGapBases("9")
        BlatParser2.setStrand("+")
        BlatParser2.setQName("TotoFM2")
        BlatParser2.setQSize("378")
        BlatParser2.setQStart("0")
        BlatParser2.setQEnd("345")
        BlatParser2.setTName("chr8")
        BlatParser2.setTSize("2205")
        BlatParser2.setTStart("2124")
        BlatParser2.setTEnd("2168")
        BlatParser2.setBlockCount("4")
        BlatParser2.setBlockSizes("76,185,7,67,")
        BlatParser2.setQStarts("0,77,263,278,")
        BlatParser2.setTStarts("21686950,21687026,21687213,21687227,")
        
        self.assertFalse(BlatParser1 == BlatParser2) 

if __name__ == "__main__":
    unittest.main()