import unittest
from commons.core.parsing.VarscanHitForGnpSNP import VarscanHitForGnpSNP
from commons.core.checker.CheckerException import CheckerException

class Test_VarscanHitForGnpSNP(unittest.TestCase):

    def test_setAttributes(self):
        lResults = ["C02HBa0291P19_LR48", "32", "C", "T", "1", "2", "66,67%", "1", "1", "37", "35", "0.3999999999999999"]
        lineNumber = 1
    
        expChrom = "C02HBa0291P19_LR48"
        expPosition = "32"
        expRef = "C"
        expVar = "T"
        expReads1 = "1"
        expReads2 = "2"
        expVarFreq = 66.67
        expStrands1 = "1"
        expStrands2 = "1"
        expQual1 = "37"
        expQual2 = "35"
        expPvalue = "0.3999999999999999"
        
        varscanHit = VarscanHitForGnpSNP()
        varscanHit.setAttributes(lResults, lineNumber)
        
        obsChrom = varscanHit.getChrom()
        obsPosition = varscanHit.getPosition()
        obsRef = varscanHit.getRef()
        obsVar = varscanHit.getVar()
        obsReads1 = varscanHit.getReads1()
        obsReads2 = varscanHit.getReads2()
        obsVarFreq = varscanHit.getVarFreq()
        obsStrands1 = varscanHit.getStrands1()
        obsStrands2 = varscanHit.getStrands2()
        obsQual1 = varscanHit.getQual1()
        obsQual2 = varscanHit.getQual2()
        obsPvalue = varscanHit.getPvalue()
        
        self.assertEquals(expChrom, obsChrom)
        self.assertEquals(expPosition, obsPosition)
        self.assertEquals(expRef, obsRef)
        self.assertEquals(expVar, obsVar)
        self.assertEquals(expReads1, obsReads1)
        self.assertEquals(expReads2, obsReads2)
        self.assertEquals(expVarFreq, obsVarFreq)
        self.assertEquals(expStrands1, obsStrands1)
        self.assertEquals(expStrands2, obsStrands2)
        self.assertEquals(expQual1, obsQual1)
        self.assertEquals(expQual2, obsQual2)
        self.assertEquals(expPvalue, obsPvalue)

    def test_setAttributes_empty_chrom(self):
        lResults = ["", "", "", "", "", "", "10", "", "", "", "", ""]
        lineNumber = 1
        
        varscanHit = VarscanHitForGnpSNP()
        checkerExceptionInstance = None
        try:
            varscanHit.setAttributes(lResults, lineNumber)
        except CheckerException, e:
            checkerExceptionInstance = e
        
        expMessage = "The field Chrom is empty in varscan file in line 1"
        obsMessage = checkerExceptionInstance.msg
           
        self.assertEquals(expMessage, obsMessage)

    def test_setAttributes_empty_position(self):
        lResults = ["chrom", "", "", "", "", "", "10", "", "", "", "", ""]
        lineNumber = 5
        
        varscanHit = VarscanHitForGnpSNP()
        checkerExceptionInstance = None
        try:
            varscanHit.setAttributes(lResults, lineNumber)
        except CheckerException, e:
            checkerExceptionInstance = e
        
        expMessage = "The field Position is empty in varscan file in line 5"
        obsMessage = checkerExceptionInstance.msg
           
        self.assertEquals(expMessage, obsMessage)

    def test_setAttributes_empty_ref(self):
        lResults = ["chrom", "position", "", "", "", "", "10", "", "", "", "", ""]
        lineNumber = 5
        
        varscanHit = VarscanHitForGnpSNP()
        checkerExceptionInstance = None
        try:
            varscanHit.setAttributes(lResults, lineNumber)
        except CheckerException, e:
            checkerExceptionInstance = e
        
        expMessage = "The field Ref is empty in varscan file in line 5"
        obsMessage = checkerExceptionInstance.msg
           
        self.assertEquals(expMessage, obsMessage)

    def test_setAttributes_empty_var(self):
        lResults = ["chrom", "position", "ref", "", "", "", "10", "", "", "", "", ""]
        lineNumber = 5
        
        varscanHit = VarscanHitForGnpSNP()
        checkerExceptionInstance = None
        try:
            varscanHit.setAttributes(lResults, lineNumber)
        except CheckerException, e:
            checkerExceptionInstance = e
        
        expMessage = "The field Var is empty in varscan file in line 5"
        obsMessage = checkerExceptionInstance.msg
           
        self.assertEquals(expMessage, obsMessage)

    def test_setAttributes_empty_reads1(self):
        lResults = ["chrom", "position", "ref", "var", "", "", "10", "", "", "", "", ""]
        lineNumber = 5
        
        varscanHit = VarscanHitForGnpSNP()
        checkerExceptionInstance = None
        try:
            varscanHit.setAttributes(lResults, lineNumber)
        except CheckerException, e:
            checkerExceptionInstance = e
        
        expMessage = "The field Reads1 is empty in varscan file in line 5"
        obsMessage = checkerExceptionInstance.msg
           
        self.assertEquals(expMessage, obsMessage)

    def test_setAttributes_empty_reads2(self):
        lResults = ["chrom", "position", "ref", "var", "reads1", "", "10", "", "", "", "", ""]
        lineNumber = 5
        
        varscanHit = VarscanHitForGnpSNP()
        checkerExceptionInstance = None
        try:
            varscanHit.setAttributes(lResults, lineNumber)
        except CheckerException, e:
            checkerExceptionInstance = e
        
        expMessage = "The field Reads2 is empty in varscan file in line 5"
        obsMessage = checkerExceptionInstance.msg
           
        self.assertEquals(expMessage, obsMessage)

    def test_setAttributes_empty_varFreq(self):
        lResults = ["chrom", "position", "ref", "var", "reads1", "reads2", "", "", "", "", "", ""]
        lineNumber = 5
        
        varscanHit = VarscanHitForGnpSNP()
        checkerExceptionInstance = None
        try:
            varscanHit.setAttributes(lResults, lineNumber)
        except CheckerException, e:
            checkerExceptionInstance = e
        
        expMessage = "The field VarFreq is empty or in bad format in varscan file in line 5"
        obsMessage = checkerExceptionInstance.msg
           
        self.assertEquals(expMessage, obsMessage)

    def test_setAttributes_empty_strands1(self):
        lResults = ["chrom", "position", "ref", "var", "reads1", "reads2", "10", "", "", "", "", ""]
        lineNumber = 5
        
        varscanHit = VarscanHitForGnpSNP()
        checkerExceptionInstance = None
        try:
            varscanHit.setAttributes(lResults, lineNumber)
        except CheckerException, e:
            checkerExceptionInstance = e
        
        expMessage = "The field Strands1 is empty in varscan file in line 5"
        obsMessage = checkerExceptionInstance.msg
           
        self.assertEquals(expMessage, obsMessage)

    def test_setAttributes_empty_strands2(self):
        lResults = ["chrom", "position", "ref", "var", "reads1", "reads2", "10", "strands1", "", "", "", ""]
        lineNumber = 5
        
        varscanHit = VarscanHitForGnpSNP()
        checkerExceptionInstance = None
        try:
            varscanHit.setAttributes(lResults, lineNumber)
        except CheckerException, e:
            checkerExceptionInstance = e
        
        expMessage = "The field Strands2 is empty in varscan file in line 5"
        obsMessage = checkerExceptionInstance.msg
           
        self.assertEquals(expMessage, obsMessage)

    def test_setAttributes_empty_qual1(self):
        lResults = ["chrom", "position", "ref", "var", "reads1", "reads2", "10", "strands1", "strands2", "", "", ""]
        lineNumber = 5
        
        varscanHit = VarscanHitForGnpSNP()
        checkerExceptionInstance = None
        try:
            varscanHit.setAttributes(lResults, lineNumber)
        except CheckerException, e:
            checkerExceptionInstance = e
        
        expMessage = "The field Qual1 is empty in varscan file in line 5"
        obsMessage = checkerExceptionInstance.msg
           
        self.assertEquals(expMessage, obsMessage)

    def test_setAttributes_empty_qual2(self):
        lResults = ["chrom", "position", "ref", "var", "reads1", "reads2", "10", "strands1", "strands2", "qual1", "", ""]
        lineNumber = 5
        
        varscanHit = VarscanHitForGnpSNP()
        checkerExceptionInstance = None
        try:
            varscanHit.setAttributes(lResults, lineNumber)
        except CheckerException, e:
            checkerExceptionInstance = e
        
        expMessage = "The field Qual2 is empty in varscan file in line 5"
        obsMessage = checkerExceptionInstance.msg
           
        self.assertEquals(expMessage, obsMessage)

    def test_setAttributes_empty_pvalue(self):
        lResults = ["chrom", "position", "ref", "var", "reads1", "reads2", "10", "strands1", "strands2", "qual1", "qual2", ""]
        lineNumber = 5
        
        varscanHit = VarscanHitForGnpSNP()
        checkerExceptionInstance = None
        try:
            varscanHit.setAttributes(lResults, lineNumber)
        except CheckerException, e:
            checkerExceptionInstance = e
        
        expMessage = "The field Pvalue is empty in varscan file in line 5"
        obsMessage = checkerExceptionInstance.msg
           
        self.assertEquals(expMessage, obsMessage)
        
    def test__eq__notEquals(self):
        varscanHit1 = VarscanHitForGnpSNP()
        varscanHit1.setChrom('C02HBa0291P19_LR48')
        varscanHit1.setPosition('32')
        varscanHit1.setRef('C')
        varscanHit1.setVar('T')
        varscanHit1.setReads1('1')
        varscanHit1.setReads2('2')
        varscanHit1.setVarFreq('66,67%')
        varscanHit1.setStrands1('1')
        varscanHit1.setStrands2('1')
        varscanHit1.setQual1('37')
        varscanHit1.setQual2('35')
        varscanHit1.setPvalue('0.3999999999999999')
        
        varscanHit2 = VarscanHitForGnpSNP()
        varscanHit2.setChrom('C02HBa0291P19_LR48')
        varscanHit2.setPosition('34')
        varscanHit2.setRef('A')
        varscanHit2.setVar('T')
        varscanHit2.setReads1('1')
        varscanHit2.setReads2('2')
        varscanHit2.setVarFreq('66,67%')
        varscanHit2.setStrands1('1')
        varscanHit2.setStrands2('1')
        varscanHit2.setQual1('40')
        varscanHit2.setQual2('34')
        varscanHit2.setPvalue('0.3999999999999999')
        
        self.assertFalse(varscanHit1 == varscanHit2)

    def test__eq__Equals(self):
        varscanHit1 = VarscanHitForGnpSNP()
        varscanHit1.setChrom('C02HBa0291P19_LR48')
        varscanHit1.setPosition('32')
        varscanHit1.setRef('C')
        varscanHit1.setVar('T')
        varscanHit1.setReads1('1')
        varscanHit1.setReads2('2')
        varscanHit1.setVarFreq('66,67%')
        varscanHit1.setStrands1('1')
        varscanHit1.setStrands2('1')
        varscanHit1.setQual1('37')
        varscanHit1.setQual2('35')
        varscanHit1.setPvalue('0.3999999999999999')
        
        varscanHit2 = VarscanHitForGnpSNP()
        varscanHit2.setChrom('C02HBa0291P19_LR48')
        varscanHit2.setPosition('32')
        varscanHit2.setRef('C')
        varscanHit2.setVar('T')
        varscanHit2.setReads1('1')
        varscanHit2.setReads2('2')
        varscanHit2.setVarFreq('66,67%')
        varscanHit2.setStrands1('1')
        varscanHit2.setStrands2('1')
        varscanHit2.setQual1('37')
        varscanHit2.setQual2('35')
        varscanHit2.setPvalue('0.3999999999999999')
        
        self.assertTrue(varscanHit1 == varscanHit2)        

    def test_formatAlleles2GnpSnp_for_Deletion(self):
        varscanHit1 = VarscanHitForGnpSNP()
        varscanHit1.setChrom('C02HBa0291P19_LR48')
        varscanHit1.setPosition('32')
        varscanHit1.setRef('C')
        varscanHit1.setVar('-ATT')
        varscanHit1.setReads1('1')
        varscanHit1.setReads2('2')
        varscanHit1.setVarFreq('66,67%')
        varscanHit1.setStrands1('1')
        varscanHit1.setStrands2('1')
        varscanHit1.setQual1('37')
        varscanHit1.setQual2('35')
        varscanHit1.setPvalue('0.3999999999999999')
        
        expPolymType = "DELETION"
        expGnpSnpRef = "ATT"
        expGnpSnpVar = "---"
        expGnpSnpPosition = 33
        
        varscanHit1.formatAlleles2GnpSnp()
        
        obsPolymType = varscanHit1.getPolymType()
        obsGnpSnpRef = varscanHit1.getGnpSnpRef()
        obsGnpSnpVar = varscanHit1.getGnpSnpVar()
        obsGnpSnpPosition = varscanHit1.getGnpSnpPosition()
        
        self.assertEquals(expPolymType,obsPolymType)
        self.assertEquals(expGnpSnpRef, obsGnpSnpRef)
        self.assertEquals(expGnpSnpVar, obsGnpSnpVar)
        self.assertEquals(expGnpSnpPosition, obsGnpSnpPosition)
        
    def test_setVarFreq(self):
        varscanHit1 = VarscanHitForGnpSNP()  
        exp = 66.67      
        varscanHit1.setVarFreq('66,67%')
        obs = varscanHit1.getVarFreq()
        self.assertEquals(exp, obs)
            
    def test_formatAlleles2GnpSnp_for_Insertion(self):
        varscanHit1 = VarscanHitForGnpSNP()
        varscanHit1.setChrom('C02HBa0291P19_LR48')
        varscanHit1.setPosition('32')
        varscanHit1.setRef('C')
        varscanHit1.setVar('+TG')
        varscanHit1.setReads1('1')
        varscanHit1.setReads2('2')
        varscanHit1.setVarFreq('66,67%')
        varscanHit1.setStrands1('1')
        varscanHit1.setStrands2('1')
        varscanHit1.setQual1('37')
        varscanHit1.setQual2('35')
        varscanHit1.setPvalue('0.3999999999999999')
        
        expPolymType = "INSERTION"
        expGnpSnpRef = "--"
        expGnpSnpVar = "TG"
        expGnpSnpPosition = 32
        
        varscanHit1.formatAlleles2GnpSnp()
        
        obsPolymType = varscanHit1.getPolymType()
        obsGnpSnpRef = varscanHit1.getGnpSnpRef()
        obsGnpSnpVar = varscanHit1.getGnpSnpVar()
        obsGnpSnpPosition = varscanHit1.getGnpSnpPosition()
        
        self.assertEquals(expPolymType,obsPolymType)
        self.assertEquals(expGnpSnpRef, obsGnpSnpRef)
        self.assertEquals(expGnpSnpVar, obsGnpSnpVar)
        self.assertEquals(expGnpSnpPosition, obsGnpSnpPosition)
        
    def test_formatAlleles2GnpSnp_for_SNP(self):
        varscanHit1 = VarscanHitForGnpSNP()
        varscanHit1.setChrom('C02HBa0291P19_LR48')
        varscanHit1.setPosition('12')
        varscanHit1.setRef('G')
        varscanHit1.setVar('T')
        varscanHit1.setReads1('1')
        varscanHit1.setReads2('2')
        varscanHit1.setVarFreq('66,67%')
        varscanHit1.setStrands1('1')
        varscanHit1.setStrands2('1')
        varscanHit1.setQual1('37')
        varscanHit1.setQual2('35')
        varscanHit1.setPvalue('0.3999999999999999')
        
        expPolymType = "SNP"
        expGnpSnpRef = "G"
        expGnpSnpVar = "T"
        expGnpSnpPosition = 12
        
        varscanHit1.formatAlleles2GnpSnp()
        
        obsPolymType = varscanHit1.getPolymType()
        obsGnpSnpRef = varscanHit1.getGnpSnpRef()
        obsGnpSnpVar = varscanHit1.getGnpSnpVar()
        obsGnpSnpPosition = varscanHit1.getGnpSnpPosition()
        
        self.assertEquals(expPolymType,obsPolymType)
        self.assertEquals(expGnpSnpRef, obsGnpSnpRef)
        self.assertEquals(expGnpSnpVar, obsGnpSnpVar)
        self.assertEquals(expGnpSnpPosition, obsGnpSnpPosition)
        

if __name__ == "__main__":
    unittest.main()