#
# Copyright INRA-URGI 2009-2011
# 
# This software is governed by the CeCILL license under French law and
# abiding by the rules of distribution of free software. You can use,
# modify and/ or redistribute the software under the terms of the CeCILL
# license as circulated by CEA, CNRS and INRIA at the following URL
# "http://www.cecill.info".
# 
# As a counterpart to the access to the source code and rights to copy,
# modify and redistribute granted by the license, users are provided only
# with a limited warranty and the software's author, the holder of the
# economic rights, and the successive licensors have only limited
# liability.
# 
# In this respect, the user's attention is drawn to the risks associated
# with loading, using, modifying and/or developing or reproducing the
# software by the user in light of its specific status of free software,
# that may mean that it is complicated to manipulate, and that also
# therefore means that it is reserved for developers and experienced
# professionals having in-depth computer knowledge. Users are therefore
# encouraged to load and test the software's suitability as regards their
# requirements in conditions enabling the security of their systems and/or
# data to be ensured and, more generally, to use and operate it in the
# same conditions as regards security.
# 
# The fact that you are presently reading this means that you have had
# knowledge of the CeCILL license and that you accept its terms.
#
import re
import sys
from commons.core.parsing.MapperParser import MapperParser
from SMART.Java.Python.structure.Mapping import Mapping
from SMART.Java.Python.structure.SubMapping import SubMapping
from SMART.Java.Python.structure.Interval import Interval

class BowtieParser(MapperParser):
    """A class that parses BowTie format"""

    def __init__(self, fileName, verbosity = 0):
        super(BowtieParser, self).__init__(fileName, verbosity)


    def __del__(self):
        super(BowtieParser, self).__del__()


    def getFileFormats():
        return ["bowtie"]
    getFileFormats = staticmethod(getFileFormats)


    def skipFirstLines(self):
        pass


    def parseLine(self, line):
        line   = line.strip()
        fields = line.split("\t")
        if len(fields) not in (7, 8):
            raise Exception("Line %d '%s' does not look like a BowTie line (number of fields is %d instead of 7 or 8)" % (self.currentLineNb, line, len(fields)))
        name         = fields[0]
        direction    = 1 if fields[1] == "+" else -1
        chromosome   = fields[2]
        genomeStart  = int(fields[3]) + 1
        sequence     = fields[4]
        quality      = fields[5]
        number       = int(fields[6])
        nbMismatches = 0
        if len(fields) == 8:
            tags         = fields[7]
            nbMismatches = len(tags.split(","))

        mapping = Mapping()
        queryInterval = Interval()
        queryInterval.setName(name)
        queryInterval.setStart(1)
        queryInterval.setEnd(len(sequence) + 1)
        targetInterval = Interval()
        targetInterval.setChromosome(chromosome)
        targetInterval.setStart(genomeStart)
        targetInterval.setEnd(genomeStart + len(sequence) - 1)
        subMapping = SubMapping()
        subMapping.setQueryInterval(queryInterval)
        subMapping.setTargetInterval(targetInterval)
        mapping.addSubMapping(subMapping)
        mapping.setSize(len(sequence))
        mapping.setNbMismatches(nbMismatches)
        mapping.setDirection(direction)
        return mapping

