import unittest
import os
from SMART.Java.Python.misc import Utils
from commons.core.utils.FileUtils import FileUtils


class Test_F_convertTranscriptFile(unittest.TestCase):

    def setUp(self):
        self._inputFileName     = None
        self._expOutputFileName = None
        self._outputFileName    = None

    def tearDown(self):
        for fileName in (self._expOutputFileName, self._outputFileName):
            if fileName != None and os.path.exists(fileName):
                os.remove(fileName)

    def test_run_SAMtoGFF3(self):
        self._inputFileName = "%s/SMART/Java/Python/test/input.sam" % (os.environ["REPET_PATH"])
        self._writeInputSam(self._inputFileName)
        self._outputFileName = '%s/SMART/Java/Python/test/obsOutput.gff3' % (os.environ["REPET_PATH"])
        cmd =  'python %s/SMART/Java/Python/convertTranscriptFile.py -i %s -f sam -o %s -g gff3 -v 0' % (os.environ["REPET_PATH"], self._inputFileName, self._outputFileName)
        os.system(cmd)
        self._expOutputFileName = '%s/SMART/Java/Python/test/expOutput.gff3' % (os.environ["REPET_PATH"])
        self._writeExpGff3File_test1(self._expOutputFileName)
        
        self.assertTrue(Utils.diff(self._expOutputFileName, self._outputFileName))
        os.remove(self._inputFileName)
        
    def test_run_BEDtoGFF3(self):
        self._inputFileName = "%s/SMART/Java/Python/TestFiles/test_distance.bed" % (os.environ["REPET_PATH"])
        self._outputFileName = '%s/SMART/Java/Python/test/obsOutput.gff3' % (os.environ["REPET_PATH"])
        cmd =  'python %s/SMART/Java/Python/convertTranscriptFile.py -i %s -f bed -o %s -g gff3 -v 0' % (os.environ["REPET_PATH"], self._inputFileName, self._outputFileName)
        os.system(cmd)
        self._expOutputFileName = '%s/SMART/Java/Python/test/expOutput.gff3' % (os.environ["REPET_PATH"])
        self._writeExpGff3File_test2(self._expOutputFileName)
        self.assertTrue(Utils.diff(self._expOutputFileName, self._outputFileName))
              
    def test_run_GFF3toCSV(self):
        self._inputFileName = "%s/SMART/Java/Python/TestFiles/mapperAnalyzerExpected.gff3" % (os.environ["REPET_PATH"])
        self._outputFileName = '%s/SMART/Java/Python/test/obsOutput.csv' % (os.environ["REPET_PATH"])
        cmd =  'python %s/SMART/Java/Python/convertTranscriptFile.py -i %s -f gff3 -o %s -g csv -v 0' % (os.environ["REPET_PATH"], self._inputFileName, self._outputFileName)
        os.system(cmd)
        self._expOutputFileName = '%s/SMART/Java/Python/test/expOutput.csv' % (os.environ["REPET_PATH"])
        self._writeExpCsvFile(self._expOutputFileName)
        
        self.assertTrue(Utils.diff(self._expOutputFileName, self._outputFileName))
              
    def test_run_GFF3toSam(self):
        self._inputFileName = "%s/SMART/Java/Python/TestFiles/mapperAnalyzerExpected.gff3" % (os.environ["REPET_PATH"])
        self._outputFileName = '%s/SMART/Java/Python/test/obsOutput.sam' % (os.environ["REPET_PATH"])
        cmd =  'python %s/SMART/Java/Python/convertTranscriptFile.py -i %s -f gff3 -o %s -g sam -v 0' % (os.environ["REPET_PATH"], self._inputFileName, self._outputFileName)
        os.system(cmd)
        self._expOutputFileName = '%s/SMART/Java/Python/test/expOutput.sam' % (os.environ["REPET_PATH"])
        self._writeExpSamFile(self._expOutputFileName)
        self.assertTrue(Utils.diff(self._expOutputFileName, self._outputFileName))

    def test_run_Gff3toWig(self):
        self._inputFileName = '%s/SMART/Java/Python/TestFiles/sorted_query.gff3' % (os.environ["REPET_PATH"])
        self._outputFileName = '%s/SMART/Java/Python/test/obsOutput.wig' % (os.environ["REPET_PATH"])
        cmd =  'python %s/SMART/Java/Python/convertTranscriptFile.py -i %s -f gff3 -o %s -g wig -v 0' % (os.environ["REPET_PATH"], self._inputFileName, self._outputFileName)
        os.system(cmd) 
        outputFile = '%s/SMART/Java/Python/TestFiles/sorted_query_wig.wig' % (os.environ["REPET_PATH"])       
        self.assertTrue(Utils.diff(outputFile, self._outputFileName))  
          
    def _writeInputSam(self, fileName):
        file = open(fileName, 'w')
        file.write( 'HWI-EAS337_3:7:1:415:1217\t83\tC02HBa0185P07_LR40\t3889\t60\t36M\t=\t3830\t-95\tACAGTGATGTAGTCCTGCGTGAAAAGTCTGCACATC\tQTUQUUWVWVVWWPVKVVVVWWWWVWWWPWVVVWWW\tXT:A:U\tNM:i:0\tSM:i:37\tAM:i:37\tX0:i:1\tX1:i:0\tXM:i:0\tXO:i:0\tXG:i:0\tMD:Z:36\n' )
        file.write( 'HWI-EAS337_3:7:1:415:1217\t163\tC02HBa0185P07_LR40\t3830\t60\t36M\t=\t3889\t95\tTAAGAACTTGGCTGATCGCCTACTTACTGCTTTTAC\tVWWWVWVVVVVVVVUVWVWVVWWVWVVVUVTTTTTN\tXT:A:U\tNM:i:0\tSM:i:37\tAM:i:37\tX0:i:1\tX1:i:0\tXM:i:0\tXO:i:0\tXG:i:0\tMD:Z:36\n' )
        file.write( 'HWI-EAS337_3:7:1:208:1489\t77\t*\t0\t0\t*\t*\t0\t0\tGGAAACATATGCACATAAACGTTGAAATCATGCTTA\tWWWWWWWWWWWWWWWWWVWWVWWVWWWWWWUUUUUU\n' )
        file.write( 'HWI-EAS337_3:7:1:208:1489\t141\t*\t0\t0\t*\t*\t0\t0\tCGTGTTTTTGGTTGTGCATAAGGCTTTTTAAAGTAA\tWWWWWWWWWVVWWQWVWVWWVUVWWWWWWVRTRTTR\n' )
        file.write( 'HWI-EAS337_3:7:1:278:1153\t77\t*\t0\t0\t*\t*\t0\t0\tGAGAAAACCTGTAATAAATACTGAGAGAAAGTAGGG\tWWWWWWWWWWWWWWWWWWWWWWVWVVVWWVUUUUUR\n' )
        file.write( 'HWI-EAS337_3:7:1:278:1153\t141\t*\t0\t0\t*\t*\t0\t0\tGTCAGGCCGCATTGATGGGGGATGGGTTTCCCCCCA\tWWWVWWWWWWWWWVVVVVVVVVVWWWVVVVTTTTTR\n' )
        file.write( 'HWI-EAS337_3:7:1:1178:755\t83\tC11SLe0053P22_LR298\t2130\t60\t36M\t=\t1980\t-186\tATTCAATGGTTTTACCATCAACCAACCACTCTCACC\tUUUUUUVVVWVWVVVVWVVWWVVWWWVWWWWWWWWW\tXT:A:U\tNM:i:0\tSM:i:37\tAM:i:37\tX0:i:1\tX1:i:0\tXM:i:0\tXO:i:0\tXG:i:0\tMD:Z:36\n' )
        file.write( 'HWI-EAS337_3:7:1:1178:755\t163\tC11SLe0053P22_LR298\t1980\t60\t36M\t=\t2130\t186\tGACATTTCAATTACATTCATCTTACCATCACCTATA\tWVWVWWWWWVWWVWWVWWVVWWWVVWVWVVTTTTTR\tXT:A:U\tNM:i:0\tSM:i:37\tAM:i:37\tX0:i:1\tX1:i:0\tXM:i:0\tXO:i:0\tXG:i:0\tMD:Z:36\n' )
        file.write( 'HWI-EAS337_3:7:1:277:1259\t99\tC06HBa0144J05_LR355\t1\t60\t36M\t=\t101\t136\tGGGTGACAAAGAAAACAAAAGGGACATGGTACTTGG\tWWWWWWWWWWWWWWWWWWWWWWVWWWWWWVUUUUUU\tXT:A:U\tNM:i:0\tSM:i:37\tAM:i:37\tX0:i:1\tX1:i:0\tXM:i:0\tXO:i:0\tXG:i:0\tMD:Z:36\n' )
        file.write( 'HWI-EAS337_3:7:1:277:1259\t147\tC06HBa0144J05_LR355\t101\t60\t36M\t=\t1\t-136\tTCTTCAAGTGATTCAGAAGATCCTGATGAGCCAAAA\tSTTTRTWWVWWVVVVWWWWWVVWWWWWWWWWWWWWW\tXT:A:U\tNM:i:0\tSM:i:37\tAM:i:37\tX0:i:1\tX1:i:0\tXM:i:0\tXO:i:0\tXG:i:0\tMD:Z:36\n' )
        file.write( 'HWI-EAS337_3:7:1:447:1231\t83\tC08HBa0165B06_LR218\t3619\t60\t36M\t=\t3575\t-80\tAGGCTCCAGCTTTCCATTCCAACTCTTCCACAAGTC\tUUSURUVVVVVVVVVWWWVWWWVWVWWWWWWWWWWW\tXT:A:U\tNM:i:0\tSM:i:37\tAM:i:37\tX0:i:1\tX1:i:0\tXM:i:0\tXO:i:0\tXG:i:0\tMD:Z:36\n' )
        file.write( 'HWI-EAS337_3:7:1:447:1231\t163\tC08HBa0165B06_LR218\t3575\t60\t36M\t=\t3619\t80\tTCAACAAGAGAAAGGAGACGAAAAAGTAAATCCAAC\tWWWWWWWWVWWWWVVWWWWWVVWWWWVVWWTTTTTR\tXT:A:U\tNM:i:0\tSM:i:37\tAM:i:37\tX0:i:1\tX1:i:0\tXM:i:0\tXO:i:0\tXG:i:0\tMD:Z:36\n' )
        file.close()
        
    def _writeExpGff3File_test1(self, fileName):
        file = open(fileName, 'w')
        file.write( 'C02HBa0185P07_LR40\tSMART\ttranscript\t3889\t3924\t.\t-\t.\tquality=60;bestRegion=(self);nbGaps=0;nbOccurrences=1;nbMismatches=0.000000;ID=HWI-EAS337_3:7:1:415:1217;identity=100.000000;Name=HWI-EAS337_3:7:1:415:1217\n')
        file.write( 'C02HBa0185P07_LR40\tSMART\ttranscript\t3830\t3865\t.\t+\t.\tquality=60;bestRegion=(self);nbGaps=0;nbOccurrences=1;nbMismatches=0.000000;ID=HWI-EAS337_3:7:1:415:1217;identity=100.000000;Name=HWI-EAS337_3:7:1:415:1217\n')
        file.write( 'C11SLe0053P22_LR298\tSMART\ttranscript\t2130\t2165\t.\t-\t.\tquality=60;bestRegion=(self);nbGaps=0;nbOccurrences=1;nbMismatches=0.000000;ID=HWI-EAS337_3:7:1:1178:755;identity=100.000000;Name=HWI-EAS337_3:7:1:1178:755\n')
        file.write( 'C11SLe0053P22_LR298\tSMART\ttranscript\t1980\t2015\t.\t+\t.\tquality=60;bestRegion=(self);nbGaps=0;nbOccurrences=1;nbMismatches=0.000000;ID=HWI-EAS337_3:7:1:1178:755;identity=100.000000;Name=HWI-EAS337_3:7:1:1178:755\n')
        file.write( 'C06HBa0144J05_LR355\tSMART\ttranscript\t1\t36\t.\t+\t.\tquality=60;bestRegion=(self);nbGaps=0;nbOccurrences=1;nbMismatches=0.000000;ID=HWI-EAS337_3:7:1:277:1259;identity=100.000000;Name=HWI-EAS337_3:7:1:277:1259\n')
        file.write( 'C06HBa0144J05_LR355\tSMART\ttranscript\t101\t136\t.\t-\t.\tquality=60;bestRegion=(self);nbGaps=0;nbOccurrences=1;nbMismatches=0.000000;ID=HWI-EAS337_3:7:1:277:1259;identity=100.000000;Name=HWI-EAS337_3:7:1:277:1259\n')
        file.write( 'C08HBa0165B06_LR218\tSMART\ttranscript\t3619\t3654\t.\t-\t.\tquality=60;bestRegion=(self);nbGaps=0;nbOccurrences=1;nbMismatches=0.000000;ID=HWI-EAS337_3:7:1:447:1231;identity=100.000000;Name=HWI-EAS337_3:7:1:447:1231\n')
        file.write( 'C08HBa0165B06_LR218\tSMART\ttranscript\t3575\t3610\t.\t+\t.\tquality=60;bestRegion=(self);nbGaps=0;nbOccurrences=1;nbMismatches=0.000000;ID=HWI-EAS337_3:7:1:447:1231;identity=100.000000;Name=HWI-EAS337_3:7:1:447:1231\n')
        file.close()
        
    def _writeExpGff3File_test2(self, fileName):
        file = open(fileName, 'w')
        file.write( 'arm_X\tSMART\ttranscript\t1000\t1999\t.\t+\t.\tID=test2.1;Name=test2.1\n' )
        file.write( 'arm_X\tSMART\ttranscript\t250\t349\t.\t+\t.\tID=test2.2;Name=test2.2\n' )
        file.write( 'arm_X\tSMART\ttranscript\t150\t249\t.\t+\t.\tID=test2.3;Name=test2.3\n' )
        file.close()
        
    def _writeExpCsvFile(self, fileName):
        file = open(fileName, 'w')      
        file.write( 'chromosome,start,end,strand,exons,ID,bestRegion,feature,identity,nbGaps,nbMismatches,nbOccurrences,occurrence,rank,score\n' )
        file.write( 'chr1,6155418,6155441,"+",None,test1/1,(self),match,100,0,0,1,1,1,24\n' )
        file.write( 'chr2,26303950,26303981,"+",None,test2/1-1,(self),match,93,0,2,3,1,1,32\n' )
        file.write( 'chr3,28320540,28320574,"+",None,test2/1-2,chr2:26303950-26303981,match,94,0,2,3,2,None,35\n' )
        file.write( 'chr4,28565007,28565041,"+",None,test2/1-3,chr2:26303950-26303981,match,88,0,4,3,3,3,35\n' )
        file.close()
        
    def _writeExpSamFile(self, fileName):
        file = open(fileName, 'w')
        file.write('@SQ\tSN:chr4\tLN:28565041\n')
        file.write('@SQ\tSN:chr3\tLN:28320574\n')
        file.write('@SQ\tSN:chr2\tLN:26303981\n')
        file.write('@SQ\tSN:chr1\tLN:6155441\n')
        file.write('test1/1\t0\tchr1\t6155418\t255\t24M\t*\t0\t0\t*\t*\tNM:i:0\n')
        file.write('test2/1\t0\tchr2\t26303950\t255\t32M\t*\t0\t0\t*\t*\tNM:i:0\n')
        file.write('test2/1\t0\tchr3\t28320540\t255\t35M\t*\t0\t0\t*\t*\tNM:i:0\n')
        file.write('test2/1\t0\tchr4\t28565007\t255\t35M\t*\t0\t0\t*\t*\tNM:i:0\n')
        file.close()


if __name__ == "__main__":
    unittest.main()
