import unittest
import os
from commons.core.utils.FileUtils import FileUtils
from SMART.Java.Python.misc import Utils


class Test_F_clusterizeBySlidingWindows(unittest.TestCase):

    def setUp(self):
        self._outputFileName         = 'output.gff3'
        self._outputCsvFileName      = 'output.csv'
        self._outputPngFileName      = 'output.png'
        self._expectedOutputFileName = 'expOut.png'
        
    def tearDown(self):
        for fileName in (self._outputFileName, self._outputCsvFileName, self._outputPngFileName, self._expectedOutputFileName):
            if os.path.exists(fileName):
                os.remove(fileName)
        
    def test_run_default_option(self):
        cmd = "python ../clusterizeBySlidingWindows.py -i ../TestFiles/mapperAnalyzerExpected.gff3 -f gff3 -o %s -s 50000 -e 50 -v 0" % (self._outputFileName)
        os.system(cmd)
        exp = '../TestFiles/clusterize_default_expected.gff3' 
        self.assertTrue(Utils.diff(exp, self._outputFileName))
        
    def test_run_default_option_map_output(self):
        self._outputFileName         = 'output.map'
        cmd = "python ../clusterizeBySlidingWindows.py -i ../TestFiles/mapperAnalyzerExpected.gff3 -f gff3 -o %s -s 50000 -e 50 -u map -v 0" % (self._outputFileName)
        os.system(cmd)
        exp = '../TestFiles/clusterize_default_expected.map' 
        self.assertTrue(Utils.diff(exp, self._outputFileName))
        
    def test_run_newTag_option(self):
        cmd = "python ../clusterizeBySlidingWindows.py -i ../TestFiles/mapperAnalyzerExpected.gff3 -f gff3 -o %s -s 50000 -e 50 -w newTag -v 0" % (self._outputFileName)
        os.system(cmd)
        exp = '../TestFiles/clusterize_output_tag_expected.gff3' 
        self.assertTrue(Utils.diff(exp, self._outputFileName))
        
    def test_run_normalize_option(self):
        cmd = "python ../clusterizeBySlidingWindows.py -i ../TestFiles/mapperAnalyzerOutput.gff3 -f gff3 -o %s -s 50000 -e 50 -m -v 0" % (self._outputFileName)
        os.system(cmd)
        exp = '../TestFiles/clusterize_normalize_expected.gff3' 
        self.assertTrue(Utils.diff(exp, self._outputFileName))

    def test_run_strand_option(self):
        cmd = "python ../clusterizeBySlidingWindows.py -i ../TestFiles/mapperAnalyzerOutput.gff3 -f gff3 -o %s -s 50000 -e 50 -2 -v 0"  % (self._outputFileName)
        os.system(cmd)
        exp = '../TestFiles/clusterize_strands_expected.gff3'
        self.assertTrue(Utils.diff(exp, self._outputFileName))

    def test_run_excel_option(self):
        cmd = "python ../clusterizeBySlidingWindows.py -i ../TestFiles/mapperAnalyzerOutput.gff3 -f gff3 -o %s -s 50000 -e 50 -x %s -v 0" % (self._outputFileName, self._outputCsvFileName)
        os.system(cmd)
        self.assertTrue(FileUtils.isRessourceExists(self._outputCsvFileName))
        
        
    def test_run_normalize_strand_excel_option(self):
        cmd = "python ../clusterizeBySlidingWindows.py -i ../TestFiles/mapperAnalyzerOutput.gff3 -f gff3 -o %s -s 50000 -e 50 -m -2 -x %s -v 0" % (self._outputFileName, self._outputCsvFileName)
        os.system(cmd)
        self.assertTrue(FileUtils.isRessourceExists(self._outputCsvFileName))
      
    def test_run_tag_operation_options(self):
        cmd = "python ../clusterizeBySlidingWindows.py -i ../TestFiles/testSW.gff3 -f gff -s 100 -e 0 -g value1 -r min -o %s -v 0" % (self._outputFileName)
        os.system(cmd)
        exp = open(self._expectedOutputFileName, 'w')
        exp.write("chr1\tS-MART\ttranscript\t1\t100\t.\t+\t.\tnbElements=0;minValue1=0;ID=region1;Name=region1\n")
        exp.write("chr1\tS-MART\ttranscript\t101\t200\t.\t+\t.\tnbElements=2.000000;minValue1=1.0;ID=region2;Name=region2\n")
        exp.write("chr1\tS-MART\ttranscript\t201\t300\t.\t+\t.\tnbElements=2.000000;minValue1=10.0;ID=region3;Name=region3\n")
        exp.close()   
        self.assertTrue(Utils.diff(self._outputFileName, self._expectedOutputFileName))
        
    def test_run_plot_options(self):
        cmd = "python ../clusterizeBySlidingWindows.py -i ../TestFiles/testSW.gff3 -f gff -s 100 -e 0 -g value1 -r min -o %s -p %s -v 0" % (self._outputFileName, self._outputPngFileName)
        os.system(cmd)     
        self.assertTrue(FileUtils.isRessourceExists(self._outputPngFileName))
        
        
if __name__ == "__main__":
    unittest.main()
