import unittest
import os, glob


class Test_F_qualToFastq(unittest.TestCase):

    def setUp(self):
        self.fastaFileName  = "file.fasta"
        self.qualFileName   = "file.qual"
        self.outputFileName = "outputFile.fastq"
         
    def tearDown(self):
        for fileRoot in (self.fastaFileName, self.qualFileName, self.outputFileName):
            for file in glob.glob("%s*" % (fileRoot)):
                os.remove(file)

    def test_run_simple(self):
        handle = open(self.fastaFileName, "w")
        handle.write(">test1\n")
        handle.write("AAAAAA")
        handle.close()
        handle = open(self.qualFileName, "w")
        handle.write(">test1\n")
        handle.write("32\t32\t32\t32\t32\t32")
        handle.close()
        os.system("python ../qualToFastq.py -f %s -q %s -o %s -v 0" % (self.fastaFileName, self.qualFileName, self.outputFileName))
        handle = open(self.outputFileName)
        lines = handle.readlines()
        self.assertEquals(len(lines), 4)
        self.assertEquals(lines[0], "@test1\n")
        self.assertEquals(lines[1], "AAAAAA\n")
        self.assertEquals(lines[2], "+\n")
        self.assertEquals(lines[3], "AAAAAA\n")

        
if __name__ == "__main__":
    unittest.main()

