library(extrafont)
loadfonts()
library(ggplot2)
data <- read.table("tmpFile26845.dat", header = T)
data$Sample <- factor(data$Sample, levels=c("Col"))
png("test.png", width = 800, height = 300)
ggplot(data, aes(x = Pos/1000000, y = Count, fill = Sample, color = Sample)) + opts(title = "Distribution") + geom_bar(stat = "identity") + facet_grid(Sample ~ Chr, space="free") + xlab(" (in Gbp)") + ylab("# reads") + scale_fill_manual(values = c("red")) + scale_color_manual(values = c("red")) + opts(legend.position = "none", panel.grid.major = theme_blank(), panel.grid.minor = theme_blank(), panel.background = theme_blank()) + theme(text=element_text(family="Arial", size=12))
dev.off()
