import os
import unittest
from commons.pyRepetUnit.align.AlignList import AlignList
from commons.pyRepetUnit.align.AlignListUtils import AlignListUtils
from commons.core.utils.FileUtils import FileUtils
from commons.core.coord.Range import Range
from commons.core.coord.Align import Align

class Test_AlignListUtils (unittest.TestCase):
    
    def setUp(self):
        self.inputFileName = "dummyAlignFile.align"
        self.outputFileName = "dummyAlignFile.out"
        
    def testRead(self):
        f = open(self.inputFileName, "w")
        f.write("blumeria_Grouper_590_20:NoCat_1\t91\t108\tDUF234\t5\t22\t2.6e-60\t0\t3.2\n")
        f.write("blumeria_Grouper_590_20:NoCat_1\t111\t119\tDUF1414\t1\t9\t6.3\t0\t2.9\n")
        f.close() 
        alignRead = AlignListUtils()      
        tableauAlignInstance = alignRead.read(self.inputFileName)            
        self.assertEquals(tableauAlignInstance.get(0).range_query.seqname, "blumeria_Grouper_590_20:NoCat_1")
        self.assertEquals(tableauAlignInstance.get(0).range_query.start, 91)
        self.assertEquals(tableauAlignInstance.get(0).range_query.end, 108)  
        self.assertEquals(tableauAlignInstance.get(0).range_subject.seqname, "DUF234")
        self.assertEquals(tableauAlignInstance.get(0).range_subject.start, 5)
        self.assertEquals(tableauAlignInstance.get(0).range_subject.end, 22)
        self.assertEquals(tableauAlignInstance.get(0).e_value, 2.6e-60) 
        self.assertEquals(tableauAlignInstance.get(0).score, 0)
        self.assertEquals(tableauAlignInstance.get(0).identity, 3.2)
        self.assertEquals(tableauAlignInstance.get(1).range_query.seqname, "blumeria_Grouper_590_20:NoCat_1")
        self.assertEquals(tableauAlignInstance.get(1).range_query.start, 111)
        self.assertEquals(tableauAlignInstance.get(1).range_query.end, 119)  
        self.assertEquals(tableauAlignInstance.get(1).range_subject.seqname, "DUF1414")
        self.assertEquals(tableauAlignInstance.get(1).range_subject.start, 1)
        self.assertEquals(tableauAlignInstance.get(1).range_subject.end, 9)
        self.assertEquals(tableauAlignInstance.get(1).e_value, 6.3)
        self.assertEquals(tableauAlignInstance.get(1).score, 0)
        self.assertEquals(tableauAlignInstance.get(1).identity, 2.9)
        os.system("rm " + self.inputFileName)
        
    def testWrite(self):
        f = open("expectedAlignFile.align", "w")
        f.write("biduleChouetteQuery\t20\t55\tbiduleChouetteSubject\t2\t15\t0.005\t20\t0.000000\n")
        f.write("trucBiduleQuery\t110\t155\ttrucBiduleSubject\t1\t35\t2\t1\t0.000000\n")
        f.write("dummyQuery\t1\t65\tdummySubject\t1\t25\t2.6e-60\t50\t0.000000\n")
        f.close()        
        listAlignInstance = AlignList()
        align1 = Align()
        align1.range_query = Range("biduleChouetteQuery", 20, 55)
        align1.range_subject = Range("biduleChouetteSubject", 2, 15)
        align1.e_value = 0.005
        align1.score = 20
        listAlignInstance.append(align1)
        align2 = Align()
        align2.range_query = Range("trucBiduleQuery", 110, 155)
        align2.range_subject = Range("trucBiduleSubject", 1, 35)
        align2.e_value = 2
        align2.score = 1.5
        listAlignInstance.append(align2)
        align3 = Align()
        align3.range_query = Range("dummyQuery", 1, 65)
        align3.range_subject = Range("dummySubject", 1, 25)
        align3.e_value = 2.6e-60
        align3.score = 50
        listAlignInstance.append(align3)
        f = open(self.outputFileName, "w")
        alignUtils = AlignListUtils()
        alignUtils.write(listAlignInstance, self.outputFileName)
        self.assertTrue(FileUtils.are2FilesIdentical(self.outputFileName, "expectedAlignFile.align"))
        os.system("rm " + self.outputFileName)        
        os.system("rm expectedAlignFile.align")
        
    def testFilterOnAMinimalScore(self):
        listAlignInstance = AlignList()
        align1 = Align()
        align1.range_query = Range("biduleChouetteQuery", 20, 55)
        align1.range_subject = Range("biduleChouetteSubject", 2, 15)
        align1.e_value = 5
        align1.score = -0.5
        listAlignInstance.append(align1)
        align2 = Align()
        align2.range_query = Range("trucBiduleQuery", 110, 155)
        align2.range_subject = Range("trucBiduleSubject", 1, 35)
        align2.e_value = 2
        align2.score = -2.0
        listAlignInstance.append(align2)
        align3 = Align()
        align3.range_query = Range("dummyQuery", 1, 65)
        align3.range_subject = Range("dummySubject", 1, 25)
        align3.e_value = 2.6e-60
        align3.score = 50
        listAlignInstance.append(align3)
        expectedAlignInstance = align3
        alignUtils = AlignListUtils()
        alignUtils.filterOnAMinimalScore(listAlignInstance, 0)
        self.assertEquals(listAlignInstance.get(0), expectedAlignInstance)
        
if __name__ == "__main__" :
    unittest.main() 