import os
import unittest
from commons.pyRepetUnit.align.transformAACoordIntoNtCoord.TransformAACoordIntoNtCoordInAlignFormat import TransformAACoordIntoNtCoordInAlignFormat
from commons.core.utils.FileUtils import FileUtils

class Test_F_TransformAACoordIntoNtCoordAndScoreFiltering (unittest.TestCase):
    
    def setUp(self):
        self._inputFile = "./datas/OutputHmmpfamTest.align"
        self._consensusFile = "./datas/ConsensusTestFile_nt.fsa"
        self._outputFile = "./datas/alignTransformedToTest.align"
        self._expectedFile = "./datas/PostPostProcessTest.align"
        self._expectedFileFiltered = "./datas/PostPostProcessTestFiltered.align"
        self._alignTransformation = TransformAACoordIntoNtCoordInAlignFormat()
    
    def testRun_with_no_filter(self):
        self._alignTransformation.setInFileName(self._inputFile)
        self._alignTransformation.setOutFileName(self._outputFile)
        self._alignTransformation.setConsensusFileName(self._consensusFile)       
        self._alignTransformation.setIsFiltered(False)
        self._alignTransformation.run()
        self.assertTrue(FileUtils.isRessourceExists(self._outputFile))
        self.assertTrue(FileUtils.are2FilesIdentical(self._expectedFile, self._outputFile))
        os.remove(self._outputFile) 
        
    def testRun_with_filter(self):
        self._alignTransformation.setInFileName(self._inputFile)
        self._alignTransformation.setOutFileName(self._outputFile)
        self._alignTransformation.setConsensusFileName(self._consensusFile)       
        self._alignTransformation.setIsFiltered(True)
        self._alignTransformation.run()
        self.assertTrue(FileUtils.isRessourceExists(self._outputFile))
        self.assertTrue(FileUtils.are2FilesIdentical(self._expectedFileFiltered, self._outputFile))
        os.remove(self._outputFile)
        
            
if __name__ == "__main__" :
    unittest.main() 