from commons.core.sql.DbFactory import DbFactory
from commons.core.utils.FileUtils import FileUtils
from commons.pyRepetUnit.convCoord.ConvSetChr2Chunk import ConvSetChr2Chunk
import unittest
import os

class Test_ConvSetChr2Chunk(unittest.TestCase):

    def setUp(self):
        self._setfilename="dummy.set"
        self._settablename="dummy_set"
        
        self._chunkmapfilename="chunk.map"
        self._chunkmaptable="test_chunk_map"
        
        self._resfilename="dummy_res.set"
        
        map4convData="chunk1\tchr1\t1\t100\n"
        map4convData+="chunk2\tchr1\t90\t200\n"
        map4convData+="chunk3\tchr1\t190\t300\n"

        map4conv=open(self._chunkmapfilename,"w")
        map4conv.write(map4convData)
        map4conv.close()
        
        self._db = DbFactory.createInstance()
        self._db.createTable(self._chunkmaptable, "map", self._chunkmapfilename, True)
        
        set2convData="1\treg1\tchr1\t10\t80\n"
        set2convData+="1\treg1\tchr1\t90\t110\n"
        set2convData+="2\treg2\tchr1\t150\t160\n"
        
        set2convData+="3\treg3\tchr1\t70\t210\n"
        set2convData+="4\treg4\tchr1\t85\t100\n"
        set2convData+="5\treg5\tchr1\t85\t110\n"
        
        set2convData+="6\treg6\tchr1\t80\t10\n"
        set2convData+="6\treg6\tchr1\t110\t90\n"
        set2convData+="7\treg7\tchr1\t160\t150\n"
        set2convData+="8\treg8\tchr1\t190\t300\n"
        
        set2convData+="9\treg9\tchr1\t210\t70\n"
        set2convData+="10\treg10\tchr1\t100\t85\n"
        set2convData+="11\treg11\tchr1\t110\t85\n"
        set2convData+="12\treg12\tchr1\t300\t190\n"
                        
        set2conv=open(self._setfilename,"w")
        set2conv.write(set2convData)
        set2conv.close()
        
        self._db.createTable(self._settablename, "set", self._setfilename, True)

        setResData="1\treg1\tchunk1\t10\t80\n"
        setResData+="1\treg1\tchunk1\t90\t100\n"
        setResData+="1\treg1\tchunk2\t1\t21\n"
        setResData+="2\treg2\tchunk2\t61\t71\n"

        setResData+="3\treg3\tchunk1\t70\t100\n"
        setResData+="3\treg3\tchunk2\t1\t111\n"
        setResData+="3\treg3\tchunk3\t1\t21\n"
        
        setResData+="4\treg4\tchunk1\t85\t100\n"
        setResData+="4\treg4\tchunk2\t1\t11\n"
        setResData+="5\treg5\tchunk1\t85\t100\n"
        setResData+="5\treg5\tchunk2\t1\t21\n"
        
        setResData+="6\treg6\tchunk1\t80\t10\n"
        setResData+="6\treg6\tchunk1\t100\t90\n"
        setResData+="6\treg6\tchunk2\t21\t1\n"
        setResData+="7\treg7\tchunk2\t71\t61\n"
        setResData+="8\treg8\tchunk2\t101\t111\n"
        setResData+="8\treg8\tchunk3\t1\t111\n"
        
        setResData+="9\treg9\tchunk1\t100\t70\n"
        setResData+="9\treg9\tchunk2\t111\t1\n"
        setResData+="9\treg9\tchunk3\t21\t1\n"
        
        setResData+="10\treg10\tchunk1\t100\t85\n"
        setResData+="10\treg10\tchunk2\t11\t1\n"
        setResData+="11\treg11\tchunk1\t100\t85\n"
        setResData+="11\treg11\tchunk2\t21\t1\n"
        setResData+="12\treg12\tchunk2\t111\t101\n"       
        setResData+="12\treg12\tchunk3\t111\t1\n"       
                
        setRes=open(self._resfilename,"w")
        setRes.write(setResData)
        setRes.close()
        
    def tearDown(self):
        self._db.dropTable(self._chunkmaptable)
        self._db.dropTable(self._settablename)
        self._db.close()
        os.remove(self._resfilename)
        os.remove(self._setfilename)
        os.remove(self._chunkmapfilename)

    def test_convert(self):
        conv = ConvSetChr2Chunk(self._db,self._settablename, self._chunkmaptable, self._settablename+"_onchk")
        conv.convert()
        obsFileName = "dummy_set.onchk"
        self._db.exportDataToFile("dummy_set_onchk", obsFileName)
        self._db.dropTable("dummy_set_onchk")
        self.assertTrue(FileUtils.are2FilesIdentical(self._resfilename, obsFileName))
        os.remove(obsFileName)

test_suite = unittest.TestSuite()
test_suite.addTest( unittest.makeSuite( Test_ConvSetChr2Chunk ) )
if __name__ == '__main__':
    unittest.TextTestRunner(verbosity=2).run( test_suite )