import os
import unittest
import ConfigParser
import commons.pyRepetUnit.hmmer.HmmpfamClusterComponent
from pyRepet.sql.RepetJobMySQL import *
from pyRepet.util.file.FileUtils import *

class TestHmmpfamClusterComponent(unittest.TestCase):

     def setUp(self):
         
        self.component = commons.pyRepetUnit.hmmer.HmmpfamClusterComponent.HmmpfamClusterComponent()
        
     def testLoadConfig(self):
        config = open("tmpConfig.cfg", "w")
        config.write("[profil_search]\n")
        config.write("ProfilDatabank: /repet_pipe/commons/pyRepetUnit/hmmer/datas/myhmms\n")
        config.write("[hmmer_config]\n")
        config.write("result_dir: /repet_results\n")
        config.write("query_dir: /repet_datas/hmmer_in_parallel\n")
        config.write("tmp_dir: /repet_tmp\n")
        config.write("[sge_config]\n")
        config.write("queue: main.q\n")
        config.write("groupid: fake\n") 
        config.close()
        config = ConfigParser.ConfigParser()
        config.readfp( open("tmpConfig.cfg") )
        self.component.loadConfig(config)
        self.assertEquals( "/repet_pipe/commons/pyRepetUnit/hmmer/datas/myhmms", self.component.getProfilDatabank() )
        self.assertEquals( "/repet_results", self.component.getResultDir() )
        self.assertEquals( "/repet_datas/hmmer_in_parallel", self.component.getQueryDir() )
        self.assertEquals( "/repet_tmp", self.component.getTmpDir() )
        self.assertEquals( "main.q", self.component.getSGEQueue() )
        self.assertEquals( "fake", self.component.getSGEGroupId() )
        os.system("rm tmpConfig.cfg") 
        
     def testClean (self):
        fileUtils = FileUtils() 
        if (fileUtils.isRessourceExists("dummyTmpDir")):
             os.system("rm -r dummyTmpDir")
         
        if (fileUtils.isRessourceExists("dummyResultDir")):
             os.system("rm -r dummyResultDir") 
         
        os.mkdir("dummyTmpDir")
        os.system("touch dummyTmpDir/srptJob1_fake_HmmpfamJob1_2009-3-11_12394.py")
        os.system("touch dummyTmpDir/srptJob2_fake_HmmpfamJob1_2009-3-11_12394.py")
        os.system("touch dummyTmpDir/srptJob3_fake_HmmpfamJob1_2009-3-11_12394.py")
        os.system("touch dummyTmpDir/srptJob4_fake_HmmpfamJob1_2009-3-11_12394.py")
        
        os.mkdir("dummyResultDir")
        os.system("touch dummyResultDir/batch_1.fa.hmmpfamOut")
        os.system("touch dummyResultDir/batch_2.fa.hmmpfamOut")
        os.system("touch dummyResultDir/batch_3.fa.hmmpfamOut")
        os.system("touch dummyResultDir/batch_4.fa.hmmpfamOut")

        self.component.setTmpDir("dummyTmpDir")
        self.component.setResultDir("dummyResultDir")
        
        self.component.clean()
        
        self.assertFalse(fileUtils.isRessourceExists("dummyTmpDir/srptJob1_fake_HmmpfamJob1_2009-3-11_12394.py"))
        self.assertFalse(fileUtils.isRessourceExists("dummyTmpDir/srptJob1_fake_HmmpfamJob2_2009-3-11_12394.py"))
        self.assertFalse(fileUtils.isRessourceExists("dummyTmpDir/srptJob1_fake_HmmpfamJob3_2009-3-11_12394.py"))
        self.assertFalse(fileUtils.isRessourceExists("dummyTmpDir/srptJob1_fake_HmmpfamJob4_2009-3-11_12394.py"))
        self.assertFalse(fileUtils.isRessourceExists("dummyResultDir/batch_1.fa.hmmpfamOut"))
        self.assertFalse(fileUtils.isRessourceExists("dummyResultDir/batch_2.fa.hmmpfamOut"))
        self.assertFalse(fileUtils.isRessourceExists("dummyResultDir/batch_3.fa.hmmpfamOut"))
        self.assertFalse(fileUtils.isRessourceExists("dummyResultDir/batch_4.fa.hmmpfamOut"))
        
        os.system("rm -r dummyTmpDir")
        os.system("rm -r dummyResultDir")
       

if __name__ == "__main__":
	unittest.main() 
