import unittest
import os
import sys

if not os.environ.has_key( "REPET_PATH" ):
    print "*** Error: no environment variable REPET_PATH"
    sys.exit(1)
sys.path.append( os.environ["REPET_PATH"] )

from pyRepet.launcher.Launcher import HmmpfamLauncher
from pyRepet.sql.RepetJobMySQL import *

class TestHmmpfamLauncher(unittest.TestCase):
    
    def testConstructor(self):
        
        params = {
                  "query" : "toto",
                  "job_table":"fakeTable", 
                  "queue" : "fakeQueue", 
                  "groupid" : "fakeId",
                  "tmpDir" : "fakeDir",
                  "cDir" : "."
        }
      
        hmmpfam = HmmpfamLauncher("toto", params)
        
        self.assertEquals("toto", hmmpfam.query)
        self.assertEquals("fakeTable", hmmpfam.job_table)
        self.assertEquals("fakeQueue", hmmpfam.queue)
        self.assertEquals("fakeId", hmmpfam.groupid)
        self.assertEquals("fakeDir", hmmpfam.tmpdir)
       
       
    def testCmd_start(self):
        
        fullInFileName = "/repet_pipe/commons/pyRepetUnit/hmmer/datas/test_input_aa.fa"
        expectedCmdStart = "hmmpfam --informat FASTA -E 10 /workspace/repet_pipe/pyRepet/launcher/datas/hmmpfam/myhmms test_input_aa.fa > /workspace/repet_pipe/commons/pyRepetUnit/hmmer/datas/test_input_aa.fa.hmmpfamOut"
        user = "oinizan"
        host = "pisano"
        passwd = "oinizan"
        dbName = "repet_oinizan"
        jobDb = RepetJob(user , host , passwd , dbName)
        params = {"param":"--informat FASTA -E 10",
                  "query" : "toto",
                  "job_table":"fake", 
                  "queue" : "fake", 
                  "groupid" : "fake",
                  "profilDB": "/workspace/repet_pipe/pyRepet/launcher/datas/hmmpfam/myhmms",
                  "tmpDir" : "fakeDir", 
                  "outputDir": "/workspace/repet_pipe/commons/pyRepetUnit/hmmer/datas", 
                  "cDir" : "."}
        self.hmmpfam = HmmpfamLauncher(jobDb, params)
        self.assertEquals(expectedCmdStart, self.hmmpfam.cmd_start ( fullInFileName ))    
        
    def testCmd_finish(self):  
        
        fullInFileName = "/workspace/repet_pipe/commons/pyRepetUnit/hmmer/datas/test_input_aa.fa"
        expectedCmdFinish = ""

        user = "oinizan"
        host = "pisano"
        passwd = "oinizan"
        dbName = "repet_oinizan"
        jobDb = RepetJob(user , host , passwd , dbName)
        params = {"param":"--informat FASTA -E 10",
                  "query" : "toto",
                  "job_table":"fake", 
                  "queue" : "fake", 
                  "groupid" : "fake",
                  "tmpDir" : "fakeDir",
                  "cDir" : "." 
                  }
        self.hmmpfam = HmmpfamLauncher(jobDb, params)
        self.assertEquals(expectedCmdFinish, self.hmmpfam.cmd_finish ( fullInFileName ))


if __name__ == "__main__":                 
	unittest.main()

