import os
import unittest
from pyRepet.launcher.programLauncher import *
from pyRepet.util.file.FileUtils import *
import ConfigParser 

if (not os.environ.has_key("REPET_PATH")):
    print "*** Error: no environment variable REPET_PATH"
    exit =1 
          
if (not os.environ.has_key("PYTHONPATH")):
    print "*** Error: no environment variable PYTHONPATH"
    exit =1
    
if (exit == 1):    
    sys.exit(1)

CONFIG_FILE = "datas/config.cfg"
CURRENT_DIR = os.getcwd()

class TestProgramLauncher(unittest.TestCase):
  
    def setUp(self):
        os.chdir(CURRENT_DIR)
        self._programLauncherInstance = programLauncher()
        self._configFile = CONFIG_FILE
        config = ConfigParser.ConfigParser()
        config.readfp( open(self._configFile) )
        self._configFile = CONFIG_FILE
        config = ConfigParser.ConfigParser()
        config.readfp(open(self._configFile))
        self._inputFile = config.get("hmmer_config", "input_file")
        self._outputFile = config.get("hmmer_config", "output_file")
        self.fileUtils = FileUtils()
    
    def testLaunchHmmpfam(self):
        config = ConfigParser.ConfigParser()
        config.readfp( open(self._configFile) )
        self._programLauncherInstance.reset( self._inputFile )
        self._programLauncherInstance.setOutputFileName( self._outputFile )
        self._programLauncherInstance.launchHmmpfam( evalFilter=config.get("profil_search","Evalue"),
                              inputFormat=config.get("profil_search","InputFormat"),
                              profilDatabank=config.get("profil_search","ProfilDatabank"))        
        self.assertTrue(self.fileUtils.isRessourceExists(self._outputFile))  
        self.assertFalse(self.fileUtils.isFileEmpty(self._outputFile))        
        os.system( "rm " + self._outputFile)
        self._inputFile = "repet_pipe/pyRepet/launcher/datas/hmmpfam/test_input_aa2.fa"
        self._programLauncherInstance.reset( self._inputFile )
        self._programLauncherInstance.launchHmmpfam( evalFilter=config.get("profil_search","Evalue"),
                              inputFormat=config.get("profil_search","InputFormat"),
                              profilDatabank=config.get("profil_search","ProfilDatabank"))
        self.assertFalse(self.fileUtils.isRessourceExists(self._outputFile))
        #No output file
        self._outputFile = ""
        self._inputFile = "repet_pipe/pyRepet/launcher/datas/hmmpfam/test_input_aa.fa"
        self._programLauncherInstance.reset( self._inputFile )
        self._programLauncherInstance.setOutputFileName( self._outputFile )
        self._programLauncherInstance.launchHmmpfam( evalFilter=config.get("profil_search","Evalue"),
                              inputFormat=config.get("profil_search","InputFormat"),
                              profilDatabank=config.get("profil_search","ProfilDatabank"))
        self.assertFalse(self.fileUtils.isRessourceExists(self._outputFile))
        os.chdir(CURRENT_DIR)
    
if __name__ == "__main__":                 
    unittest.main()
