"""
Utility to handle a databank of HMM profiles.
"""

import sys
from commons.pyRepetUnit.profilesDB.Profiles import Profiles
from commons.pyRepetUnit.profilesDB.ProfilesDatabank import ProfilesDatabank
from commons.core.utils.FileUtils import FileUtils

class ProfilesDatabankUtils:
    """
    Utility to handle a databank of HMM profiles.
    """
    
    def read( inFileName, verbose=0 ):
        """
        Read a file in Pfam format and return a L[ProfilesDatabank<commons.core.ProfilesDatabank>} instance.
        @param inFileName: name of the input file
        @type inFileName: string
        @param verbose: verbosity level
        @type verbose: integer
        """ 
        if verbose > 0: print "reading file '%s'..." % ( inFileName ); sys.stdout.flush()
        
    
        if FileUtils.isEmpty(inFileName):
            return (None)
        profilesInstance = Profiles() 
        profilesDBInstance = ProfilesDatabank()
        f = open( inFileName , "r")
        while profilesInstance.read( f ):
            profilesDBInstance.append( profilesInstance )
            profilesInstance = Profiles()
        f.close()
        if verbose > 0: print "file '%s' is loaded" % ( inFileName ); sys.stdout.flush()
        return (profilesDBInstance)
    
    read = staticmethod( read )
