#!/usr/bin/env python
'''
Created on 19 mai 2009

@author: choede
'''

import commons.pyRepetUnit.profilesDB.CompleteAProfilesDBFromAFileWithProfilesNamesOrAccNumber
import user, os, sys, getopt, exceptions
from pyRepet.util.file.FileUtils import *

#------------------------------------------------------------------------------

def help():

    """
    Give the command-line parameters.
    """

    print ""
    print "usage: ",sys.argv[0],"[ options ]"
    print "options:"
    print "     -h: this help"
    print "     -d: name of profiles databank (format='pfam')"
    print "     -l: name of the profiles list file (name or accession number, default=profiles name)"
    print "     -o: name of the output file (default=profiles list file+'.getz')"
    print "     -v: verbose (default=0/1/2)"
    print "     -n: pfam accession number (default=Not set)"
    print ""

#------------------------------------------------------------------------------

def main():

    DBFileName = ""
    outFileName = ""
    verbose = 0
    listFileName = ""
    accNumber = False

    try:
        opts,args=getopt.getopt(sys.argv[1:],"hd:l:o:v:n")
    except getopt.GetoptError, err:
        print str(err)
        help()
        sys.exit(1)
    for o,a in opts:
        if o == "-h":
            help()
            sys.exit(0)
        elif o == "-d":
            DBFileName = a
        elif o == "-l":
            listFileName = a
        elif o == "-o":
            outFileName = a
        elif o == "-v":
            verbose = int(a)
        elif o == "-n":
            accNumber = True
        
            
    if DBFileName == "" or listFileName == "":
        print "*** Error: missing compulsory options"
        help()
        sys.exit(1)

    if verbose > 0:
        print "beginning of %s" % (sys.argv[0].split("/")[-1])
        sys.stdout.flush()

    if outFileName == "":
        outFileName = "%s.getz" % ( listFileName )
     
    CompleteProfilesDB = commons.pyRepetUnit.profilesDB.CompleteAProfilesDBFromAFileWithProfilesNamesOrAccNumber.CompleteAProfilesDBFromAFileWithProfilesNamesOrAccNumber()
    CompleteProfilesDB.setProfilesDBFile ( DBFileName )
    CompleteProfilesDB.setProfilesToAdd ( listFileName )
    if accNumber == True:
        CompleteProfilesDB.setPfamAccNumberKeys ()
        if verbose > 0:
            print "The profiles list is in Accession number"
            sys.stdout.flush()
    getzCmd = CompleteProfilesDB.CmdToCompleteProfileDB()
    f = open( outFileName , 'w')
    f.write ( getzCmd )
    f.close()

    if verbose > 0:
        fileUtils = FileUtils( )
        if fileUtils.isRessourceExists( outFileName ) and not(fileUtils.isFileEmpty( outFileName )):
            print "%s finished successfully" % (sys.argv[0].split("/")[-1])
            sys.stdout.flush()
        else:
            print "warning %s execution failed" % (sys.argv[0].split("/")[-1])
            sys.stdout.flush()

    return 0

#------------------------------------------------------------------------------

if __name__ == '__main__':
    main()