#! /usr/bin/env python
#
# Copyright INRA-URGI 2009-2010
# 
# This software is governed by the CeCILL license under French law and
# abiding by the rules of distribution of free software. You can use,
# modify and/ or redistribute the software under the terms of the CeCILL
# license as circulated by CEA, CNRS and INRIA at the following URL
# "http://www.cecill.info".
# 
# As a counterpart to the access to the source code and rights to copy,
# modify and redistribute granted by the license, users are provided only
# with a limited warranty and the software's author, the holder of the
# economic rights, and the successive licensors have only limited
# liability.
# 
# In this respect, the user's attention is drawn to the risks associated
# with loading, using, modifying and/or developing or reproducing the
# software by the user in light of its specific status of free software,
# that may mean that it is complicated to manipulate, and that also
# therefore means that it is reserved for developers and experienced
# professionals having in-depth computer knowledge. Users are therefore
# encouraged to load and test the software's suitability as regards their
# requirements in conditions enabling the security of their systems and/or
# data to be ensured and, more generally, to use and operate it in the
# same conditions as regards security.
# 
# The fact that you are presently reading this means that you have had
# knowledge of the CeCILL license and that you accept its terms.
#
"""Find TSS from short reads"""
import os
from optparse import OptionParser
from SMART.Java.Python.structure.TranscriptListsComparator import TranscriptListsComparator
from SMART.Java.Python.structure.TranscriptContainer import TranscriptContainer
from commons.core.writer.Gff3Writer import Gff3Writer

if __name__ == "__main__":
    
    # parse command line
    description = "Find TSS v1.0.1: Find the transcription start site of a list of transcripts. [Category: Merge]"

    parser = OptionParser(description = description)
    parser.add_option("-i", "--input",     dest="inputFileName", action="store",                     type="string", help="input file [compulsory] [format: file in transcript format given by -f]")
    parser.add_option("-f", "--format",    dest="format",        action="store",                     type="string", help="format of file [compulsory] [format: transcript file format]")
    parser.add_option("-o", "--output",    dest="output",        action="store",      default=None,  type="string", help="output file [compulsory] [format: output file in GFF3 format]")
    parser.add_option("-n", "--normalize", dest="normalize",     action="store_true", default=False,                help="normalize the number of reads per cluster by the number of mappings per read [format: bool] [default: false]")
    parser.add_option("-d", "--distance",  dest="distance",      action="store",      default=10,    type="int",    help="distance between two reads to mark the same TSS [format: int] [default: 10]")
    parser.add_option("-e", "--colinear",  dest="colinear",      action="store_true", default=False,                help="group by strand [format: bool] [default: false]")
    parser.add_option("-c", "--csv",       dest="csv",           action="store",      default=None,  type="string", help="output a CSV file in the given path [format: output file in Excel format]")
    parser.add_option("-v", "--verbosity", dest="verbosity",     action="store",      default=1,     type="int",    help="trace level [format: int]")
    (options, args) = parser.parse_args()

    transcriptContainer = TranscriptContainer(options.inputFileName, options.format, options.verbosity)        
    transcriptListComparator = TranscriptListsComparator(None, options.verbosity)
    transcriptListComparator.restrictToStart(transcriptListComparator.QUERY, 1)
    transcriptListComparator.setMaxDistance(options.distance)
    transcriptListComparator.aggregate(True)
    transcriptListComparator.computeOdds(True)
    transcriptListComparator.getColinearOnly(options.colinear)
    transcriptListComparator.setNormalization(options.normalize)
    transcriptListComparator.setInputTranscriptContainer(transcriptListComparator.QUERY, transcriptContainer)
    transcriptListComparator.setOutputWriter(Gff3Writer(options.output, options.verbosity))
    transcriptListComparator.compareTranscriptListSelfMerge()

    if options.csv != None:
        csvResults = transcriptListComparator.getOddsPerTranscript()
        csvFile    = open(options.csv, "w")
        csvFile.write("Number,Transcript\n")
        for number in sorted(list(set(csvResults.values()))):
            csvFile.write("%d," % (number))
            for name in csvResults:
                if csvResults[name] == number:
                    csvFile.write("%s " % (name))
            csvFile.write("\n")
        csvFile.close()

